// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef DATA_GRAM_H
#define DATA_GRAM_H

#include "dataCom.h"
#include "controlData.h"

/** \defgroup monitorDriver  monitor and driver related class
    This is base class for self sufficient entity class (meaning data as well as control).
    The sub class will implement data and control related functions.
    E.g.
    The rasDataGramT should inherit from this,implement data and control.
    Basically it should have pointer to dataPayloadT(for carrying payload) and pointer to
    controlDataT(for side band info).

    The interface monitor/driver should use  interface specific instance of dataGram(rasDataGramT).

*/

class dataGramT {
 public:
  dataGramT(const char * nameP = NULL);
  dataGramT(dataComT * dataCom,sidebandControlT * sideband,const char * nameP = NULL);
  virtual ~dataGramT();

  sidebandControlT * getSidebandControlP() const;
  void setSidebandControlP(sidebandControlT * _control);
  virtual unsigned int getDataSize();
  void setDataComP(dataComT *);
  dataComT * getDataComP() const;
 protected:
  
 private:
  dataGramT(const dataGramT & rhs,const char * nameP = NULL){} 
  sidebandControlT * sidebandControl;
  dataComT * dataComP;
  void setup();
};
#endif





