// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "dataPayload.h"


dataPayloadT::dataPayloadT(const char * nameP) : 
  dataComT(nameP) {
}

/********************************************************************************************/
dataPayloadT::dataPayloadT(unsigned size,const char * nameP) :
  dataComT(nameP),
  payload(size,0) {
}

/********************************************************************************************/
dataPayloadT::dataPayloadT(vector<uint8> x,const char * nameP) : 
  dataComT(nameP)
{
  setDataAsBytes(x);
}

/********************************************************************************************/
dataPayloadT::dataPayloadT(const dataPayloadT &rhs){
  operator=(rhs);
}

/********************************************************************************************/
dataPayloadT& dataPayloadT::operator=(const dataPayloadT &rhs){
  dataComT::operator=(rhs);
  payload = rhs.getPayloadAsBytes();
  return *this;
}

/********************************************************************************************/
dataPayloadT * dataPayloadT::duplicate(){
  return (new dataPayloadT(*this));
}
/********************************************************************************************/
dataPayloadT::~dataPayloadT(){

}
/********************************************************************************************/
vector<uint8> dataPayloadT::getPayloadAsBytes() const { 
  return payload;
}

/********************************************************************************************/
vector<uint8> dataPayloadT::getHeaderAsBytes() const { 
  return vector<uint8>();
}

/********************************************************************************************/
vector<uint8> dataPayloadT::getTrailerAsBytes() const { 
  return vector<uint8>();
}
/********************************************************************************************/
void dataPayloadT::setPayloadAsBytes(const vector<uint8> & payload) {
 this->payload = payload; 
}

/********************************************************************************************/
void dataPayloadT::setHeaderAsBytes (const vector<uint8> & header) {
  // does nothing, no header
}

/********************************************************************************************/
void dataPayloadT::setTrailerAsBytes(const vector<uint8> & trailer) {
  // does nothing
}

/********************************************************************************************/
void dataPayloadT::selfExtract() {
  // what for this???
}

/********************************************************************************************/
dataComPtr dataPayloadT::extract(){
  return this;
}

/********************************************************************************************/
void dataPayloadT::randomPayload(){
  
  int size = payload.size();
  payload.erase(payload.begin(), payload.end());
                        //clear the old data before generate the new data

  for (int i = 0; i < size; i++)
  {
    uint8 random;
    random = rand()%255;
    payload.push_back(random);
  }

}
/*********************************************************************************/
ostream& dataPayloadT::printDataCom(ostream &ostr) const {
  ostr<<"PAYLOAD : "<<endl;
  printVector(ostr,payload);
  return ostr;
}
