// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "dataProvider.h"

dataProviderT::dataProviderT():
    dataGramRefBagMutex( "dataGramRef Bag Mutex"),
    totalNoOfPacketsSent(0),
    totalPackets(0)
{
}

/**************************************************************************/
dataProviderT::~dataProviderT(){
}

/********************************************************************************************/
flowMemT & dataProviderT::getFlowMem()
{
  return flowMem;
}

/*********************************************************************************************/
void dataProviderT::setTotalPackets(unsigned int pkts){
  totalPackets = pkts;
}

/**************************************************************************/
tbvBagT<dataGramT *> dataProviderT::getDataGramRef(unsigned int fid)
{
  return dataGramRefs[fid];
}

/**************************************************************************/
dataGramT * dataProviderT::frontCell(unsigned int fid)
{  
  if(cellQueueSize(fid) <= 0){
    fillQueue(fid);
  }
  return cellQueue[fid].front();
}

/**************************************************************************/
void    dataProviderT::fillQueue(unsigned int fid)
{
  
  list<dataGramT *> * cells = getListOfCells(fid);
  pushCellsToCellQueue(cells,fid);
  delete cells;
  
}
/**************************************************************************/
int dataProviderT::cellQueueSize(unsigned int fid)
{
  return  cellQueue[fid].size();
}
/**************************************************************************/
void dataProviderT::popCell(unsigned int fid)
{
  cellQueue[fid].pop();
}


/**************************************************************************/
void dataProviderT::pushCell(dataGramT * dataGramP,unsigned int key)
{
  cellQueue[key].push(dataGramP);
}

/**************************************************************************/
void dataProviderT::pushCellsToCellQueue(list<dataGramT *>* cells,unsigned int fid){
  list<dataGramT *>::iterator cellIter;
  for(cellIter = cells->begin();cellIter != cells->end();++cellIter){
    pushCell(*cellIter,fid);
  }
}

/**************************************************************************/
bool dataProviderT::done(){
  if(totalNoOfPacketsSent >= totalPackets && allQueuesEmpty()){
    return true;
  }
  else
    return false;
}

/**************************************************************************/
bool dataProviderT::allQueuesEmpty(){
  map<unsigned int,queue<dataGramT *> >::iterator iter;
  bool allQueuesEmpty = true;
  for(iter = cellQueue.begin();iter != cellQueue.end();++iter){
   queue<dataGramT *> q = ((*iter).second) ;
   if(q.empty()!= true){
     allQueuesEmpty = false;
     break;
   }
  }
  return allQueuesEmpty;
}

