// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef DATA_PROVIDER_H
#define DATA_PROVIDER_H

#include "stl.h"
#include "TestBuilder.h"
#include "dataGram.h"
#include "dataPayload.h"
#include "flowMem.h"
/** \ingroup trafficGenerator data generator
    This class upon request generates patterns and puts into a queue.
    The pure virtual function is provided, that must be implememted at block 
    level that provides implemetation of instructing generator to generate
    certain pattern of data on fids.

    trafficSchedulerTask's job is to request for a cell for a given fid 
    when is scheduled to send and this objest provides cells untill presets
    no. of cells are generated.

    This class and trafficSchedulerTaskT works like suplier/consumer.

*/

/* Small note on setting up traffic generator with new flow mem:

   The old tbvMemoryMapT has been removed.The flowMemT has portParamT and flowParamT.
   Generator need primary key(fid) and secondary key to rotate(port).
   So it has to know secondary key list(port list) and promary key list(fid list),
   moreover it has to know port weight and fid weight.Fow each primary key seconday
   key is linked.

   So call
   1)dataProvider.getFlowMem().linkFidToPort(unsigned int fid, unsigned int port, float weight = 1.0)
   to setup flow parameter and to link fid to port.
   
   2)dataProvider.getFlowMem().setPortParam(unsigned int port, PORT_PARA_TYPE type, float data);
   to setup port with port weight.
   
   Thats it!!!.
*/

typedef dataGramT * dataGramTPtr;

class dataProviderT {
 public:
  dataProviderT();

  virtual ~dataProviderT();


  /** returns ref. to flowMemT which has  perPort, perFid  maps */
  flowMemT &                       getFlowMem();
  
  /** generator is going generate no. of eops set by this function */
  void                          setTotalPackets(unsigned int);
  
  /** \param datacomP  is the prototypes to generate */
  virtual void                          addDataGramRef(dataGramT * dataGramP,unsigned int key,
						       unsigned int num = 1) = 0;
  virtual  tbvBagT<dataGramT *>        getDataGramRef(unsigned int fid) = 0;
  virtual void                          removeDataGramRef(dataGramT * dataGramP,unsigned int key) = 0;

  
  /** returns front cell from the queue indexed by \param fid */
  virtual dataGramT *                 frontCell(unsigned int fid);

  /** pops cell from cellQueue which indexed by \param fid */
  virtual void                          popCell(unsigned int fid);

  /** returns true if generator is done with generating traffic */
  virtual bool                          done();

  virtual bool rotate(const dataGramT * dataGramP) = 0;
  
 protected:

  /** Returns the Q size of the cellQueue which is indexed on \param fid */
  int                           cellQueueSize(unsigned int fid);


  /** fills the cellQueue whenever asked to */
  void                          fillQueue(unsigned int fid);
  
  /** pushes the \param datacomP into cellQueue, index is fid which is found in datacomP */
  void                          pushCell(dataGramT * dataGramP,unsigned int key);
  virtual list<dataGramT *> *  getListOfCells(unsigned int fid) = 0;
  
   /** Mutex for datacomRef bag */
  tbvMutexT dataGramRefBagMutex;

  /** the bag holds the predefind packet or cell to
  generate. The new packet/cell is generated from
  the ref packet/cell by calling randomPayload()
  on a copy of the ref. This key of this map is
  flow id. when a packet/cell needs to be generated
  for a certain fid, the generator first checks to
  see if the datacomRefs[fid] exist or not, if yes,
  use it. if not, use datacomTypes[port] for that
  fid.
  */
  map<unsigned int, tbvBagT<dataGramT *> >       dataGramRefs;
  unsigned int totalNoOfPacketsSent;
  bool allQueuesEmpty();

 private:
  map<unsigned int,queue<dataGramT *> > cellQueue; 
  unsigned int                          totalPackets;
  /** flow memory holds all the information about flow, qos, port */
  flowMemT                         flowMem;


  
  void                                  pushCellsToCellQueue(list<dataGramT *>* cells,
							     unsigned int fid);

  
};

#endif


