// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "interfaceDriverTask.h"

interfaceDriverTaskT::interfaceDriverTaskT(tbvTvmT *tvm,tbvSignalHdlT  & _clk, 
                                           tbvSignalHdlT  & _reset, const char *nameP) :
    backgroundTaskT(nameP),
    posEdgeClk ( _clk, tbvThreadT::POSEDGE ),
    notReset ( _reset, 1 ),
    clk(& _clk),
    reset(& _reset),
    interfaceDriverFiber(tvm, nameP),
    interfaceDriverQueue (getNameP())
{
    interfaceDriverFiber.setRecording(TRUE);
    setup();
}


/******************************************************************************************/
interfaceDriverTaskT::interfaceDriverTaskT(tbvTvmT *tvm,const char *nameP) :
    backgroundTaskT(nameP),
    interfaceDriverFiber(tvm, nameP),
    interfaceDriverQueue (getNameP())
{
    interfaceDriverFiber.setRecording(TRUE);
    setup();
}
/******************************************************************************************/

interfaceDriverTaskT::~interfaceDriverTaskT(){}

/******************************************************************************************/
void  interfaceDriverTaskT::pushIntoInterfaceDriverQueue(dataGramT * dataGram){
  
//    dataComT * dataCom = dataGram->getDataComP();
    interfaceDriverQueue.push(dataGram);
}

/******************************************************************************************/
dataGramT * interfaceDriverTaskT::popFromInterfaceDriverQueue(){
    dataGramT * dataGram;
    interfaceDriverQueue.pop(dataGram);
    return dataGram;
}

/******************************************************************************************/
vector<uint16> interfaceDriverTaskT::getDataBy16(vector<uint8> originalData) const
{
    vector<uint16>  dataVectorOf16bits = vector<uint16>();
    uint16  data;
    int     size8;
    int     size16;
    int     index8;
    int     index16;
    int     j;
    int     ratio = 2;   
    // it takes ratio = 2 elements from vector<uint8> to 
    // form vector<uint16>
  
    vector<uint8>  vtmp = originalData;
    size8 = vtmp.size();
    size16 = (int) ceil(0.5*size8);
  
    index16 = 0;
    while (index16 < size16)
        {
            data = 0;
            j = 0;
            while (j < ratio)
                {
                    index8 = ratio*index16 + j;
                    if (index8 < size8) 
                        {
                            data = data<<8;
                            data = data + vtmp[index8];
                        } else {
                            data = data<<8;
                        }
                    j++;
                }
      
            dataVectorOf16bits.push_back(data);
            index16++;
        }
  
  
    return dataVectorOf16bits;
} 


/**************************************************************************/
vector<uint32>   interfaceDriverTaskT::getDataBy32(vector<uint8> originalData) const
{
    vector<uint32>  dataVectorOf32Bits = vector<uint32>();
    uint32  data;
    int     size8;
    int     size32;
    int     index8;
    int     index32;
    int     j;
    int     ratio = 4;   
    // it takes ratio = 4 elements from vector<uint8> to 
    // form vector<uint32>
  
    vector<uint8>  vtmp = originalData;
    size8 = vtmp.size();
    size32 = (int) ceil(0.25*size8);
  
    index32 = 0;
    while (index32 < size32)
        {
            data = 0;
            j = 0;
            while (j < ratio)
                {
                    index8 = ratio*index32 + j;
                    if (index8 < size8) 
                        {
                            data = data<<8;
                            data = data + vtmp[index8];
                        } else {
                            data = data<<8;
                        }
                    j++;
                }
      
            dataVectorOf32Bits.push_back(data);
            index32++;
        }
  
    return dataVectorOf32Bits;
}  
/**************************************************************************/
vector<uint64>  interfaceDriverTaskT::getDataBy64(vector<uint8> originalData) const
{
    vector<uint64>  dataVectorOf64Bits =  vector<uint64>();
    uint64  data;
    int     size8;
    int     size64;
    int     index8;
    int     index64;
    int     j;
    int     ratio = 8;   
    // it takes ratio = 8 elements from vector<uint8> to 
    // form vector<uint64>
  
  
    vector<uint8>  vtmp = originalData;
    size8 = vtmp.size();
    size64 = (int) ceil(0.125*size8);
  
    index64 = 0;
    while (index64 < size64)
        {
            data = 0;
            j = 0;
            while (j < ratio)
                {
                    index8 = ratio*index64 + j;
                    if (index8 < size8) 
                        {
                            data = data<<8;
                            data = data + vtmp[index8];
                        } else {
                            data = data<<8;
                        }
                    j++;
                }
    
            dataVectorOf64Bits.push_back(data);
            index64++;
        }
  
    return dataVectorOf64Bits;
}
/******************************************************************************************/

tbvSignalHdlT & interfaceDriverTaskT::getClk(){
    return * clk;
}

/******************************************************************************************/
tbvFiberT & interfaceDriverTaskT::getFiber(){
    return interfaceDriverFiber;
}
/******************************************************************************************/
void interfaceDriverTaskT::setup(){

}
//  /******************************************************************************************/
//  void interfaceDriverTaskT::stop(){

//    running = false;
//  }

//  /******************************************************************************************/
//  void interfaceDriverTaskT::start(){
//    running = true;
//  }
