// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef INTERFACE_DRIVER_TASK_H 
#define INTERFACE_DRIVER_TASK_H

#include "TestBuilder.h"
#include "dataGram.h"
#include "backgroundTask.h"
#include "tvmAutoRegister.h"

/** \ingroup monitorDriver  base class for all interface drivers.
    Base class for all interface driver classes.
    Inherited class are expected to implement body().

    This class takes  care recording transactions into fiber,starting and stoping of thread.
    
    In addition there is a interfaceDriverQueue (tbvMailbox), the data gram to be driven  must be pushed 
    this queue;
    
*/
typedef unsigned short uint16;
typedef tbvUInt32T uint32;
typedef tbvUInt64T uint64;
  
class interfaceDriverTaskT : public backgroundTaskT {
 public:
  interfaceDriverTaskT(tbvTvmT *tvm,tbvSignalHdlT  & _clk, tbvSignalHdlT  & _reset, 
	       const char *nameP = NULL);
  interfaceDriverTaskT(tbvTvmT *tvm,const char *nameP = NULL);
  ~interfaceDriverTaskT();

  /// pushes \param dataGram into interfaceDriverQueue. 
  void  pushIntoInterfaceDriverQueue(dataGramT * dataGram); 
    
 protected:
 
 
  dataGramT * popFromInterfaceDriverQueue();
  tbvSignalHdlT & getClk();

  /// get the whole data in vector of 16 bits. This is used to serilize the data to write on the databus.
  vector<uint16>        getDataBy16(vector<uint8> originalData) const;
  
  ///get the whole data in vector of 32 bits.
  vector<uint32>        getDataBy32(vector<uint8> originalData) const;
  
  /// get the whole data in vector of 64 bits.
  vector<uint64>        getDataBy64(vector<uint8> originalData) const;
  
//  virtual void body(tbvSmartDataT * data = NULL) = 0;
  tbvFiberT & getFiber();
  
  tbvEventExprT posEdgeClk;
  tbvEventExprT notReset;

 private:
  tbvSignalHdlT * clk;
  tbvSignalHdlT * reset;
  tbvFiberT interfaceDriverFiber;
  tbvMailboxT<dataGramT *> interfaceDriverQueue;
  void setup();
};

#endif
