// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MESSAGE_H
#define MESSAGE_H

#include "TestBuilder.h"
/** \ingroup messagingStructure messages
 This class provides place holder for message type(see messageType enum in messageSch.h)
    and place holder for relevent data to supplied to message handler.
    
    Typical usage is:
    messageT & msg = messageResponderT::createMessage();
    msg.setMessage(messageT::LUT_PORT_UNDEF);
    msg.setUserMessagestring("lut port not initialised");
    msg.setData(tbvCell);
    messageResponderT::report(msg);

*/

class messageT : public tbvSmartRecordT{
 public:
  messageT(const char * nameP = NULL);
  ~messageT();

  /*
  typedef enum{
   PARITY_ERROR,
   BAD_CRC
  } messageType;
  */
  typedef int messageType;
  static const messageType LOG = 0;
  static const messageType BAD_CRC = 1;
  static const messageType ILLEGAL_OPERATION = 2;
  
  typedef int severityLevel;
  static const severityLevel WARNING = 1;
  static const severityLevel ERROR = 2;

  void setMessage(messageType msg);
  void setData(tbvSmartDataT * data);
  void setUserMessageString(string msg);
  void setSeverityLevel(severityLevel severity);

  const int getMessage();
  tbvSmartDataT * getData();
  string getUserMessageString();
  const int getSeverityLevel();


 protected:
  
 private:
  messageType message;
  tbvSmartDataT * data;
  string userMessageString;
  severityLevel severity;
  void setup();
  void wrapup();
};

#endif
 
