// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "messageResponder.h"

tbvMailboxT<tbvSafeHandleT<messageT> > * messageResponderT::messageQueue = 
new  tbvMailboxT<tbvSafeHandleT<messageT> >("messageQueue");

messageResponderT::messageResponderT(const char * nameP) :
  backgroundTaskT(nameP){
  setup();
}

messageResponderT::~messageResponderT(){
  delete messageQueue;
}
void messageResponderT::report(tbvSafeHandleT<messageT> msg){
  messageQueue->push(msg);
}


void messageResponderT::body(){
  
  tbvSafeHandleT<messageT> msg;
  messageQueue->pop(msg);
  // once msg is obtained get the message handler object for this message and
  // spawn those messageHandler
  // (e.g. get the object which deals with messageT::LUT_PORT_UNDEF)
  //check whether a msg Handler is registered with this message else
  // call default message(log message)
  
  messageHandlerT * msgHandler;
  if(messageTypeToMessageHandler.find(msg->getMessage()) != messageTypeToMessageHandler.end()){
    msgHandler = messageTypeToMessageHandler[msg->getMessage()];
    // duplicate pointer to data before calling run(..),B'se msg will be deleted immediately
    msgHandler->spawn(msg);
  }
  else{
    //log the message
    if(msg->getSeverityLevel() == messageT::ERROR)
      tbvOut<<" ERROR: ";
    if(msg->getSeverityLevel() == messageT::WARNING)
      tbvOut<<" WARNING: ";
    
    tbvOut<<msg->getUserMessageString()<<" Occured"<<endl;
  }
}


void messageResponderT::registerMessageWithMessageHandler(messageT::messageType msg ,
							  messageHandlerT * msgHandler){
  messageTypeToMessageHandler[msg] = msgHandler;
}
void messageResponderT::unregisterMessageWithMessageHandler(messageT::messageType msg){
 delete  messageTypeToMessageHandler[msg];
 messageTypeToMessageHandler.erase(msg);
}

tbvSafeHandleT<messageT> messageResponderT::createMessage(){
  return tbvSafeHandleT<messageT>(new messageT());
}
/*
void messageResponderT::start(){
  this->spawn();
}

void messageResponderT::stop(){
  tbvThreadT myThread = tbvThreadT::self();
  myThread.kill();
}
*/
void messageResponderT::setup(){
}

