// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "memRasDriver.h"

TVM_VERILOG_REGISTER(memRasDriverTvmT::create , "memRasDriverTvm" );

memRasDriverTaskT::memRasDriverTaskT(memRasDriverTvmT & tvm, const char * nameP):
  interfaceDriverTaskT(&tvm,nameP),
  memRasInterface(tvm)
{
}


/****************************************************************************************************/

memRasDriverTaskT::~memRasDriverTaskT(){
}

/****************************************************************************************************/
void memRasDriverTaskT::body(){
  
  //get dataGramT * from mail box,get memRasSidebandControlT and dataPayloadT from dataGramT.
  // Drive all mem to ras side band signals from memRasSidebandControlT and data from dataPayloadT.


//  debugOutput()<<"#############ras driver spawned @ time =  " << tbvGetInt64Time(TBV_NS) << "   " << running<<endl;
    tbvThreadT::yield();
    dataGramT * dataGram = popFromInterfaceDriverQueue(); 
    dataComT * dataCom = NULL;
    memRasSidebandControlT memRasSidebandControl;
    
    // The thread goes to sleeping state untill atleast one entry is there in mail box.
    
    // check whether dataPayloadT is NULL or not, if it is NULL,register message with message handler.
    if(dataGram->getDataComP() == NULL){
      tbvSafeHandleT<messageT> msg = (messageResponderT::createMessage());
      (*msg).setMessage(messageT::ILLEGAL_OPERATION);
      (*msg).setUserMessageString("NO DATA DETECTED:From mem to ras driver NULL poite in dataGram is detected");
      messageResponderT::report(msg);
      debugOutput()<<"ERROR: dataComp is NULL"<<endl;
    }else{
      dataCom = dataGram->getDataComP();
    }

    vector<uint64> data = getDataBy64(dataCom->getDataAsBytes());
    
    //Check whether memRasSidebandControlT is NULL or not, If it is NULL it is one of the fatal error
    // condition.
    if(dataGram->getSidebandControlP() != NULL){
      
    }else{
      memRasSidebandControl = *((memRasSidebandControlT *)(dataGram->getSidebandControlP()));
    }
    
    //Now we got side and as well data in memRasSidebandControl and dataPayload.

     while (tbv4StateNotEqual(memRasInterface.reset_l, 1)){
      tbvWaitCycle(memRasInterface.clk, tbvThreadT::POSEDGE);
    }

        
   debugOutput()<<"from Driver @ time = " << tbvGetInt64Time(TBV_NS) << "   " << *dataCom<<endl;


    memRasInterface.mem_ras_available = 1;
    
    for (unsigned int i = 0; i < data.size(); i++)
      {
	// wait for one more cycle to put data on bus
	memRasInterface.mem_ras_data(127,64) = data[i];
	i++;
	if (i <  data.size())
	  {
	    memRasInterface.mem_ras_data(63,0) = data[i];
	  }
	else
	  {
	    memRasInterface.mem_ras_data(63,0) = 0;
	  }
	
	tbvWaitCycle(memRasInterface.clk, tbvThreadT::POSEDGE);
	tbvWaitCycle(memRasInterface.clk, tbvThreadT::POSEDGE);
      }
    delete dataGram;
    debugOutput() << dec << "@" << tbvGetInt64Time(TBV_NS) << ": Verilog data: RasDriver " << memRasInterface.mem_ras_data << endl;
     memRasInterface.mem_ras_available = 0;


}
  
  

/****************************************************************************************************/
//                                    Mem to Ras interface Tvm
/****************************************************************************************************/
memRasDriverTvmT::memRasDriverTvmT( const char *nameP) :
  //tbvTvmT(),
  reset_l(getFullInterfaceHdlNameP("reset_l") ),
  clk(getFullInterfaceHdlNameP("clk") ),
  gsync(getFullInterfaceHdlNameP("gsync") ),
  mem_ras_available(getFullInterfaceHdlNameP("mem_ras_available_o") ),
  mem_ras_cell_length(getFullInterfaceHdlNameP("mem_ras_cell_length") ),
  mem_ras_cid(getFullInterfaceHdlNameP("mem_ras_cid") ),
  mem_ras_clp(getFullInterfaceHdlNameP("mem_ras_clp") ),
  mem_ras_data(getFullInterfaceHdlNameP("mem_ras_data_o") ),
  mem_ras_efci(getFullInterfaceHdlNameP("mem_ras_efci") ),
  mem_ras_eof(getFullInterfaceHdlNameP("mem_ras_eof") ),
  mem_ras_eop(getFullInterfaceHdlNameP("mem_ras_eop") ),
  mem_ras_mlppp_length(getFullInterfaceHdlNameP("mem_ras_mlppp_length") ),
  mem_ras_param(getFullInterfaceHdlNameP("mem_ras_param") ),
  mem_ras_portid(getFullInterfaceHdlNameP("mem_ras_portid") ),
  mem_ras_qid(getFullInterfaceHdlNameP("mem_ras_qid") ),
  mem_ras_sof(getFullInterfaceHdlNameP("mem_ras_sof") ),
  mem_ras_sop(getFullInterfaceHdlNameP("mem_ras_sop") ),
  mem_ras_tid(getFullInterfaceHdlNameP("mem_ras_tid") ),
  mem_ras_tidqid(getFullInterfaceHdlNameP("mem_ras_tidqid") ),
  mem_ras_type(getFullInterfaceHdlNameP("mem_ras_type_o") ),
  ras_in_en(getFullInterfaceHdlNameP("ras_in_en") ),
  ras_out_en(getFullInterfaceHdlNameP("ras_out_en") ),
  ras_mem_ctrl_pop(getFullInterfaceHdlNameP("ras_mem_ctrl_pop") ),
  ras_mem_data_pop(getFullInterfaceHdlNameP("ras_mem_data_pop") ),
  
  memRasDriverTask( * this, "ras Driver"  )
{

}

/****************************************************************************************************/

memRasDriverTvmT::~memRasDriverTvmT(){
  //delete pointer if any
}
/****************************************************************************************************/
void memRasDriverTvmT::create(){
  new memRasDriverTvmT();
}







