// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MEM_RAS_DRIVER_H
#define MEM_RAS_DRIVER_H


#include "TestBuilder.h"
#include "common/interfaceDriverTask.h"
#include "common/dataGram.h"
#include "common/dataPayload.h"
#include "../sideband/memRasSidebandControl.h"
#include "common/message.h"
#include "common/messageResponder.h"

/** \ingroup monitorDriver  memory to reassembly driver.
    It has one tvm(to connect to HDL signals of the design) called memRasDriverTvmT,
    and one task to drive signals called memRasDriverTaskT.

    The memRasDriverTaskT inherits from intefaceDriverTaskT.The siganls to be stimulated
    is passed through a mail box(tbvMailboxT ,which is a queue with semophore), which is 
    defined in memRasDriverTaskT.

    The task is spawned only once and keeps waiting on mail box untill asked to stop.
    
    Pre-requisits: The memRasControlT must be defined which will have all mem to ras
    side band control signals.

*/


class memRasDriverTvmT;


class memRasDriverTaskT : public interfaceDriverTaskT {
 public:
  memRasDriverTaskT(memRasDriverTvmT & tvm, const char * nameP = NULL);
  ~memRasDriverTaskT();
  memRasDriverTvmT & memRasInterface;
  void body ();
};

/***************************************************************************************************/

class memRasDriverTvmT : public tbvTvmT 
{
 public:
  memRasDriverTvmT(const char * nameP = NULL);
  ~memRasDriverTvmT();
  
  //hdl interface signals
  tbvSignalHdlT   reset_l;
  tbvSignalHdlT   clk;
  tbvSignalHdlT   gsync;
  
  tbvSignalHdlT   mem_ras_available;
  tbvSignalHdlT   mem_ras_cell_length;
  tbvSignalHdlT   mem_ras_cid;
  tbvSignalHdlT   mem_ras_clp;
  tbvSignalHdlT   mem_ras_data;
  tbvSignalHdlT   mem_ras_efci;
  tbvSignalHdlT   mem_ras_eof;
  tbvSignalHdlT   mem_ras_eop;
  //tbvSignalHdlT   mem_ras_lfi_type;
  tbvSignalHdlT   mem_ras_mlppp_length;
  tbvSignalHdlT   mem_ras_param;
  tbvSignalHdlT   mem_ras_portid;
  tbvSignalHdlT   mem_ras_qid;
  tbvSignalHdlT   mem_ras_sof;
  tbvSignalHdlT   mem_ras_sop;
  tbvSignalHdlT   mem_ras_tid;
  tbvSignalHdlT   mem_ras_tidqid;
  tbvSignalHdlT   mem_ras_type;

  tbvSignalHdlT   ras_in_en;
  tbvSignalHdlT   ras_out_en;

  tbvSignalHdlT   ras_mem_ctrl_pop;
  tbvSignalHdlT   ras_mem_data_pop;
  
  memRasDriverTaskT memRasDriverTask;
  

  // This function is called from $tbv_tvm_connect, to Create a TVM object.
  static void create ( );
 protected:
 private:

};

#endif
