// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef RAS_DATA_GEN
#define RAS_DATA_GEN

#include "common/dataProvider.h"
#include "common/dataGram.h"
#include "../sideband/memRasSidebandControl.h"
#include <stl.h>

/* \ingroup generator reassemly specific data generator
   This class inhehits dataProviderT, implements pure virtual function
   list<dataGramT *> *  getListOfCells(dataGramTT dataGramP).
   
   tbvTrafficGenTaskT is consumer and this is suplier.
   
*/

class reassemblyDataGenT : public dataProviderT {
 public:
  reassemblyDataGenT();
  ~reassemblyDataGenT();
  
  bool setupTraffic(memRasSidebandControlT * sidebandControl);
  void                          addDataGramRef(dataGramT * dataGramP,unsigned int qid,
					       unsigned int num = 1);
  tbvBagT<dataGramT *>        getDataGramRef(unsigned int fid);
  void                          removeDataGramRef(dataGramT * dataGramP,unsigned int qid);
  bool rotate(const dataGramT * dataGramP);
 protected:
 private:
  list<dataGramT *> *  getListOfCells(unsigned int fid);
  void connectGenerator(dataGramT * dataGram,float perQidWeight = 1.0,
			float perPortWeight = 1.0);
  void setup();
  
};

#endif
