// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------


// Module name: ras_top_verif.v
// Author:      Leena Singh
// 
// Description: 
//  The ras_top_verif module is the top-level RAS verification module, 
//  which is used to instantiate all of Reassembly's top level module 
//  and other verification monitors, generators, checkers  and signals.
//*************************************************************** 


`timescale 1ns/1ns

module ras_top_verif    ();

   reg           reset_l;
   reg 	         clk;
   wire 	   gsync;     // global sync

   wire [5:0] 	   cpu_addr;
   wire [31:0]    cpu_data_in;
   wire 	   cpu_ras_cs_l;
   wire 	   cpu_rdwr_l;   

   wire           mem_ras_available;   
   wire [12:0]	   mem_ras_cid;   
   wire [6:0] 	   mem_ras_cell_length;   
   wire 	   mem_ras_clp;      
   wire [127:0]   mem_ras_data; 
   wire 	   mem_ras_efci;
   wire 	   mem_ras_eof;   
   wire 	   mem_ras_eop;
   wire [1:0] 	   mem_ras_lfi_type; 
   wire [3:0] 	   mem_ras_mlppp_length;
   wire [15:0]    mem_ras_param;  // incoming cell parameters (pass through) 
   wire [6:0] 	   mem_ras_portid; // incoming cell's port id       
   wire [19:0]    mem_ras_qid;    // incoming cell's queue id (pass through)
   wire 	   mem_ras_sof;   
   wire 	   mem_ras_sop;   // start of packet
   wire [18:0]    mem_ras_tid;   // tunnel id (pass through)
   wire 	   mem_ras_tidqid;   
   wire [3:0] 	   mem_ras_type;  // cell type

   wire 	   ras_in_en;
   wire 	   ras_out_en;
   
// Outputs

   wire 	   ras_cpu_intr;       // ras to cpu interrupt
   wire [31:0]   ras_cpu_data_out;   // ras to cpu data
   
   wire 	   ras_mem_ctrl_pop;   // ctrl pop is used for rest of epe ctrl
   wire 	   ras_mem_data_pop;   // data pop is used with data & byte_en

   
   wire [127:0]  ras_epe_data;
   wire [15:0]   ras_epe_byte_en;   

   wire [6:0]    ras_epe_bytecnt;
   wire [6:0]    ras_epe_bytecnt_adj;      
   wire 	   ras_epe_cell;   
   wire [12:0]   ras_epe_cid;
   wire 	   ras_epe_eop;
   wire 	   ras_epe_packet;   
   wire [15:0]   ras_epe_param;   
   wire [6:0]    ras_epe_portid;      
   wire [19:0]   ras_epe_qid;
   wire 	   ras_epe_sop;
   wire [18:0]   ras_epe_tid;
   wire 	   ras_epe_tidqid;   
   wire [3:0]    ras_epe_type;
   wire 	   ras_epe_crc32_err;
   wire 	   ras_epe_aal5len_err;
   wire 	   ras_epe_mtu_err;   
   wire 	   ras_epe_nonzero_cpi;
   

always @(posedge reset_l)
        $display("\nOUT OF RESET\n");


initial
   begin
     #1;
     $display("now calling c from verilog");
     #0 $tbv_main();
     $display(" Verilog start wave @ time=%d", $time);
   end


initial  begin
         $display("initial statement from verilog");
         reset_l = 0;
         clk = 0;
         #500 reset_l = 1;
         end
 

parameter CLK_PERIOD = 2.5;
always
 begin
  clk  = #CLK_PERIOD ~clk;
  //$display("at %d clk = %x " , $time, clk);
 end

// Ras Top instantiation 

/* -----\/----- EXCLUDED -----\/-----
ras_top    ras_top(
                   // inputs
                   reset_l,
                   clk,
                   gsync,

                   cpu_ras_cs_l,
                   cpu_rdwr_l,
                   cpu_addr,
                   cpu_data_in,

                   mem_ras_available,
                   mem_ras_cell_length,
                   mem_ras_cid,
                   mem_ras_clp,
                   mem_ras_data,
                   mem_ras_efci,
                   mem_ras_eof,
                   mem_ras_eop,
                   mem_ras_lfi_type,
                   mem_ras_mlppp_length,
                   mem_ras_param,
                   mem_ras_portid,
                   mem_ras_qid,
                   mem_ras_sof,
                   mem_ras_sop,
                   mem_ras_tid,
                   mem_ras_tidqid,
                   mem_ras_type,

                   ras_in_en,
                   ras_out_en,

                   // outputs
                   ras_mem_ctrl_pop,
                   ras_mem_data_pop,

                   ras_cpu_data_out,
                   ras_cpu_intr,

                   ras_epe_byte_en,
		   ras_epe_bytecnt,
		   ras_epe_bytecnt_adj,
		   ras_epe_cell,
		   ras_epe_cid,
		   ras_epe_crc32_err,
		   ras_epe_data,
		   ras_epe_eop,
		   ras_epe_length_err,
		   ras_epe_nonzero_cpi,
		   ras_epe_param,
		   ras_epe_packet,
		   ras_epe_portid,
		   ras_epe_qid,
		   ras_epe_sop,
		   ras_epe_tid,
		   ras_epe_tidqid,
		   ras_epe_type

                  );
 -----/\----- EXCLUDED -----/\----- */

   trafficSchedulerTvm trafficScheduler(.rst_l(reset_l), .clk(clk)
					);
memRasDriverTvm memRasDriver(
                   .reset_l(reset_l),
                   .clk(clk),
                   .gsync(gsync),

                   .mem_ras_available(mem_ras_available),
                   .mem_ras_cell_length(mem_ras_cell_length),
                   .mem_ras_cid(mem_ras_cid),
                   .mem_ras_clp(mem_ras_clp),
                   .mem_ras_data(mem_ras_data),
                   .mem_ras_efci(mem_ras_efci),
                   .mem_ras_eof(mem_ras_eof),
                   .mem_ras_eop(mem_ras_eop),
                   .mem_ras_lfi_type(mem_ras_lfi_type),
                   .mem_ras_mlppp_length(mem_ras_mlppp_length),
                   .mem_ras_param(mem_ras_param),
                   .mem_ras_portid(mem_ras_portid),
                   .mem_ras_qid(mem_ras_qid),
                   .mem_ras_sof(mem_ras_sof),
                   .mem_ras_sop(mem_ras_sop),
                   .mem_ras_tid(mem_ras_tid),
                   .mem_ras_tidqid(mem_ras_tidqid),
                   .mem_ras_type(mem_ras_type)


);

memRasMonitorTvm memRasMonitor(
                   reset_l,
                   clk,
                   gsync,


                   mem_ras_available,
                   mem_ras_cell_length,
                   mem_ras_cid,
                   mem_ras_clp,
                   mem_ras_data,
                   mem_ras_efci,
                   mem_ras_eof,
                   mem_ras_eop,
                   mem_ras_lfi_type,
                   mem_ras_mlppp_length,
                   mem_ras_param,
                   mem_ras_portid,
                   mem_ras_qid,
                   mem_ras_sof,
                   mem_ras_sop,
                   mem_ras_tid,
                   mem_ras_tidqid,
                   mem_ras_type,

                   ras_in_en,
                   ras_out_en,

                   ras_mem_ctrl_pop,
                   ras_mem_data_pop

);

memRasMonitorTvm memRasMonitorTemp(
                   reset_l,
                   clk,
                   gsync,


                   mem_ras_available,
                   mem_ras_cell_length,
                   mem_ras_cid,
                   mem_ras_clp,
                   mem_ras_data,
                   mem_ras_efci,
                   mem_ras_eof,
                   mem_ras_eop,
                   mem_ras_lfi_type,
                   mem_ras_mlppp_length,
                   mem_ras_param,
                   mem_ras_portid,
                   mem_ras_qid,
                   mem_ras_sof,
                   mem_ras_sop,
                   mem_ras_tid,
                   mem_ras_tidqid,
                   mem_ras_type,

                   ras_in_en,
                   ras_out_en,

                   ras_mem_ctrl_pop,
                   ras_mem_data_pop

);




endmodule // ras_top_verif


