// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "reassemblyTestcase.h"

CPPUNIT_TEST_SUITE_NAMED_REGISTRATION( reassemblyTestcaseSuiteT, string("reassembly") );

void reassemblyTestcaseSuiteT::setUp() {

    //  reassemblyDataGenTvmT reassemblyDataGenT = ( reassemblyDataGenT&) *tbvTvmT::getTvmByInstanceNameP("rasDataProvider");

    checkerStream   = new ofstream("checker",  ios::out);
    driverStream    = new ofstream("driver",   ios::out);
    inputMonitorStream   = new ofstream("input_monitor",  ios::out);
    outputMonitorStream   = new ofstream("output_monitor",  ios::out);
    schedulerStream = new ofstream("scheduler",ios::out);

    trafficSchedulerTvm  = (trafficSchedulerTvmT *)   tbvTvmT::getTvmByInstanceNameP("trafficScheduler");
    memRasDriverTvm  = (memRasDriverTvmT *)   tbvTvmT::getTvmByInstanceNameP("memRasDriver");  
    inputMonitor         = (memRasMonitorTvmT *)  tbvTvmT::getTvmByInstanceNameP("memRasMonitor");
    outputMonitor        = (memRasMonitorTvmT *)  tbvTvmT::getTvmByInstanceNameP("memRasMonitorTemp");

    rasChecker      = new reassemblyCheckerT();
    rasDataProvider = new reassemblyDataGenT();
    rasMonitorDispatch      = new cellDispatcherTaskT();

    rasMonitorDispatch->registerProcessHandleWithMonitor(& inputMonitor->memRasMonitorTask, & checkerT::processInput, *rasChecker);
    rasMonitorDispatch->registerProcessHandleWithMonitor(& outputMonitor->memRasMonitorTask, & checkerT::processOutput, *rasChecker);

    trafficSchedulerTvm->trafficSchedulerTask.connectDataProvider(rasDataProvider);  
    trafficSchedulerTvm->trafficSchedulerTask.addTask(& memRasDriverTvm->memRasDriverTask);

    rasChecker->setDebugOutputStream(checkerStream);
    inputMonitor->memRasMonitorTask.setDebugOutputStream(inputMonitorStream);
    outputMonitor->memRasMonitorTask.setDebugOutputStream(outputMonitorStream);
    memRasDriverTvm->memRasDriverTask.setDebugOutputStream(driverStream);
    trafficSchedulerTvm->trafficSchedulerTask.setDebugOutputStream(schedulerStream);  
}


void reassemblyTestcaseSuiteT::tearDown() {
    delete checkerStream;
    delete driverStream;
    delete inputMonitorStream;
    delete outputMonitorStream;
    delete schedulerStream;
    delete rasDataProvider;
    delete rasMonitorDispatch;
}

void reassemblyTestcaseSuiteT::testMustPass() { CPPUNIT_ASSERT(1); }
