// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "simpleRasTest.h"


CPPUNIT_TEST_SUITE_NAMED_REGISTRATION( simpleRasTest, string("reassembly") );

void simpleRasTest::setUp() {
    tbvRandomT::setSeedGenerationAlgorithm(tbvRandomT::RAND48, NULL, 3999, 2);
    // all outputs of integer should show the base 
    // ("0" prefix for Oct, "0x" for Hex)
    tbvOut.setf(ios::showbase);

    // explicitly call that which virtual functions will call itself
    reassemblyTestcaseSuiteT::setUp();
  
}

void simpleRasTest::tearDown() {

    // explicitly call that which virtual functions will call itself
    reassemblyTestcaseSuiteT::tearDown();
}


void simpleRasTest::testMustPass() {
    tbvOut << "Begin Sample test.........." << endl;
    rasDataProvider->setTotalPackets(10);
    memRasSidebandControlT * rasSidebandControl = new memRasSidebandControlT();
    rasSidebandControl->mem_ras_type = 0;
    rasSidebandControl->mem_ras_qid = 10;
    rasSidebandControl->mem_ras_portid = 1;
    rasDataProvider->setupTraffic(rasSidebandControl);
    tbvOut << "Starting Sample test.........." << endl; 
  
    rasMonitorDispatch->start();
    trafficSchedulerTvm->trafficSchedulerTask.start();
    memRasDriverTvm->memRasDriverTask.start();
    rasChecker->start();

    cout<<"###spawned all tasks"<<endl;
    tbvWait(2000, TBV_NS);
  
    tbvOut<<"Finished Waiting..." << endl;
    rasMonitorDispatch->stop();
    memRasDriverTvm->memRasDriverTask.stop();
    trafficSchedulerTvm->trafficSchedulerTask.stop();
    rasChecker->stop();

    tbvOut << "Complete Sample test.........." << endl;
    delete rasSidebandControl;

    tbvThreadT::waitDescendants();
    CPPUNIT_ASSERT(rasChecker->mismatches == 0);
}

void simpleRasTest::testProbablyMustPass() {
    testMustPass();
}
