// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef _pl3TXGEN_H
#define _pl3TXGEN_H

#include "TestBuilder.h"
#include "tbvCell.h"
#include "tbvPkt.h"

class pl3TxGenTvmT;

// ****************************************
// a task pl3TxGen 
// ****************************************

/// The main task which generates the controls and the data

class pl3TxGenTaskT : public tbvTaskTypeSafeT<tbvCellT> {
  public:
    //parent tvm, make it easy to access in task body
    pl3TxGenTvmT& pl3TGen;
    tbvSmartUnsignedT randBit; // To generate random bits

    //constructor, destructor
    pl3TxGenTaskT ( pl3TxGenTvmT& );
    virtual ~pl3TxGenTaskT();

    //body function for task functionality
    virtual void body ( tbvCellT *arg );
};


// ****************************************
// a task pl3TxQueue 
// ****************************************

/// The main task which generates the controls and the data if non-blocking logic

/// This task should be spawned if non-blocking logic is defined - 
/// If the status of the current port doesn't allow the data to be sent,  
/// the task puts the transfer data into a queue and then goes to the next port.
/// If the queue is not empty and the status now is OK - the blocking task \a pl3TxGenTaskT is called.

class pl3TxQueueTaskT : public tbvTaskTypeSafeT<tbvCellT> {
  private:
    pl3TxGenTvmT& pl3TGen;
    pl3TxGenTaskT& mainTxTask;

  public:
    pl3TxQueueTaskT (pl3TxGenTvmT& pl3TGen, pl3TxGenTaskT& mainTxTask);
    virtual ~pl3TxQueueTaskT();

    //body function for task functionality
    virtual void body ( tbvCellT *arg );
};


// ****************************************
// a task pl3TxFull 
// ****************************************

/// This task is used if non-blocking logic is defined

/// This task should be spawned from \a pl3TxStatTaskT if the generations are done, but 
/// the queue is not empty and the status per port changes from 0 to 1 
/// It calls the blocking task \a pl3TxGenTaskT 

class pl3TxFullTaskT : public tbvTaskT {
  private:
    pl3TxGenTvmT& pl3TGen;
    pl3TxGenTaskT& mainTxTask;
    
  public:
    pl3TxFullTaskT (pl3TxGenTvmT& pl3TGen, pl3TxGenTaskT& mainTxTask);
    virtual ~pl3TxFullTaskT();

    //body function for task functionality
    virtual void body (tbvSmartDataT *);
};


// ****************************************
// a task pl3TxStat 
// ****************************************

/// This task is used for monitoring the status per port

/// The status task should be spawned by \a runStatTaskT

class pl3TxStatTaskT : public tbvTaskTypeSafeT<tbvCellT> {
  public:
    //parent tvm, make it easy to access in task body
    pl3TxGenTvmT& pl3TGen;

    //constructor, destructor
    pl3TxStatTaskT ( pl3TxGenTvmT& );
    virtual ~pl3TxStatTaskT();

    //body function for task functionality
    virtual void body ( tbvCellT *arg );
};


// ****************************************
// a task runStat 
// ****************************************

/// This task is used for spawning the status task \a pl3TxStatTaskT

class runStatTaskT : public tbvTaskT
{
  public:
    //parent tvm, make it easy to access in task body
    pl3TxGenTvmT& pl3TGen;

    //constructor, destructor
    runStatTaskT ( pl3TxGenTvmT& );
    virtual ~runStatTaskT();

    //body function for task functionality
    virtual void body ( tbvSmartDataT * );
};


// ****************************************
// a TVM pl3TxGen
// ****************************************

/// The main class for implementing the pl3 Tx generator

class pl3TxGenTvmT : public tbvTvmT
{

  public:
    //constructor, destructor
    pl3TxGenTvmT ();
    virtual ~pl3TxGenTvmT();

    //hdl interface signals
tbvSignalHdlT   pp3tfclk;
tbvSignalHdlT   rst_l;
tbvSignalHdlT   pp3tenb_n;
tbvSignalHdlT   pp3tsx;
tbvSignalHdlT   pp3tadr;
tbvSignalHdlT   pp3tdat;
tbvSignalHdlT   pp3tsop;
tbvSignalHdlT   pp3teop;
tbvSignalHdlT   pp3tmod;
tbvSignalHdlT   pp3tprty;
tbvSignalHdlT   pp3terr;
tbvSignalHdlT   pp3ptpa;
tbvSignalHdlT   pp3stpa;


    // The posPhyIf Mutex
    tbvMutexT pl3TxGenMutex;
    tbvMutexT pl3TxQueueMutex;
    tbvMutexT pl3TxFullMutex;
    tbvMutexT pl3TxStatMutex;
    tbvMutexT fullStatQueueMutex;

    // the recording fiber is needed to avoid using the parent task fiber
    tbvFiberT pl3TxGenFiber;
    tbvFiberT pl3TxQueueFiber;
    tbvFiberT pl3TxFullFiber;

    //basic tasks 
    pl3TxGenTaskT pl3TxGen;
    pl3TxQueueTaskT pl3TxQueue;
    pl3TxFullTaskT pl3TxFull;
    pl3TxStatTaskT pl3TxStat;
    runStatTaskT runStat;
    bool running;
    void start(){running = true;}
    void stop();

    unsigned int port_stat[64];
    unsigned int port_cnt;
    unsigned int prtySense;
    unsigned int badParity;
    unsigned int badMode;
    unsigned int curr_port;
    list<int> port_list;
    vector<int> port_index;

    void setPort_cnt(unsigned int k){port_cnt = k;}
    void setPrtySense(unsigned int k){prtySense = k;}
    void setBadParity(unsigned int k){badParity = k;}
    void setBadMode(unsigned int k){badMode = k;}
    void setPort_list(list<int> & k){port_list = k;}

    unsigned int statFull;
    void setStatFull(unsigned int k){statFull = k;}

    vector<tbvCellT *> fullStatQueue;

    // Event Expressions
    tbvEventExprT posedge_clk;
    tbvEventExprT not_reset;

   // This function is called from $tbv_tvm_connect, to Create a TVM object.
    static void create ( );


};


#endif
