// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

//****************************************************************
module pl3TxGenTvm(pp3tfclk,
                    rst_l,
                    pp3tenb_n,
                    pp3tsx,
                    pp3tadr,
                    pp3tdat,
                    pp3tsop,
	            pp3teop,
                    pp3tmod,
                    pp3tprty,
                    pp3terr,
                    pp3ptpa,
                    pp3stpa);

input               pp3tfclk;
input               rst_l;

input               pp3ptpa;
input               pp3stpa;

output              pp3tenb_n;
output              pp3tsx;
output   [5:0]      pp3tadr;
output   [31:0]     pp3tdat;
output              pp3tsop;
output              pp3teop;
output   [1:0]      pp3tmod;
output              pp3tprty;
output              pp3terr;



// These registers are driven from C++
reg           pp3tenb_n_o;
reg           pp3tsx_o;
reg  [5:0]    pp3tadr_o;
reg  [31:0]   pp3tdat_o;
reg           pp3tsop_o;
reg           pp3teop_o;
reg  [1:0]    pp3tmod_o;
reg           pp3tprty_o;
reg           pp3terr_o;


  // These assignments create Verilog drivers for the C++ regs
assign pp3tenb_n = pp3tenb_n_o;
assign pp3tsx = pp3tsx_o;
assign pp3tadr = pp3tadr_o;
assign pp3tdat = pp3tdat_o;
assign pp3tsop = pp3tsop_o;
assign pp3teop = pp3teop_o;
assign pp3tmod = pp3tmod_o;
assign pp3tprty = pp3tprty_o;
assign pp3terr = pp3terr_o;

  //
  //  register every instance of this TVM to test builder
  //
  initial
    $tbv_tvm_connect;


  initial
  begin
    pp3tenb_n_o = 0;
    pp3tsx_o = 0;
    pp3tadr_o = 0;
    pp3tdat_o = 0;
    pp3tsop_o = 0;
    pp3teop_o = 0;
    pp3tmod_o = 0;
    pp3tprty_o = 0;
    pp3terr_o = 0;
  end


endmodule



