// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#include "TestBuilder.h"
#include "tbvCell.h"
#include "tbvMonitorTask.h"


class spi4IfMonTvmT;


// ****************************************
// a task spi4CtlDatMon 
// ****************************************

/// The main task which monitors the  basic controls and the data

/// This task collects the data and some of the control fields - valid, sop, input port, output port 
/// It runs the second task \a spi4CtlMonTaskT, which collects the rest of the control fields - eop, 
/// odd/even number of bytes and odd parity over the data  

class spi4CtlDatMonTaskT : public tbvMonitorTaskT {
  public:
    //parent tvm, make it easy to access in task body
    spi4IfMonTvmT& spi4IfMonTvm;

    //constructor, destructor
    spi4CtlDatMonTaskT ( spi4IfMonTvmT& );
    virtual ~spi4CtlDatMonTaskT();

    //body function for task functionality
    virtual void monitorBody ( tbvCellT *arg );

     tbvDataComT * allocate();

};


// ****************************************
// a task spi4CtlMon 
// ****************************************

/// This task monitors some of the control fields - eop, odd/even number of bytes and odd parity 

/// This task is being run by the main task \a spi4CtlDatMonTaskT 

class spi4CtlMonTaskT : public tbvMonitorTaskT {
  public:
    //parent tvm, make it easy to access in task body
    spi4IfMonTvmT& spi4IfMonTvm;

    //constructor, destructor
    spi4CtlMonTaskT ( spi4IfMonTvmT& );
    virtual ~spi4CtlMonTaskT();

    //body function for task functionality
    virtual void body ( tbvCellT *arg );

     tbvDataComT * allocate();

};


// ****************************************
// a task spi4StatMon
// ****************************************

/// This task monitors the status of the ports 

class spi4StatMonTaskT : public tbvTaskTypeSafeT<tbvCellT>
{
  public:
    //parent tvm, make it easy to access in task body
    spi4IfMonTvmT& spi4IfMonTvm;

    //constructor, destructor
    spi4StatMonTaskT(spi4IfMonTvmT& );
    virtual ~spi4StatMonTaskT();

    //body function for task functionality
    virtual void body(tbvCellT *spi4MonArgP );
};



// ****************************************
// a TVM spi4IfMonTvm
// ****************************************

/// The main class for implementing the spi4 monitor

class spi4IfMonTvmT : public tbvTvmT
{

  public:

  vector <uint8> celldata;
  vector <uint16> mon_data; 
  unsigned int temp_cntr0;
//  unsigned int dip4;

    //constructor, destructor
    spi4IfMonTvmT ();
    virtual ~spi4IfMonTvmT();

    //hdl interface signals
tbvSignalHdlT   dclk;
tbvSignalHdlT   sclk ;
tbvSignalHdlT   reset ;
tbvSignalHdlT   dat;
tbvSignalHdlT   ctl;
tbvSignalHdlT   stat;


    // The  Mutex

    tbvSemT   spi4MonSem; 
    tbvMutexT spi4CtlDatMonMutex;
    tbvMutexT spi4CtlMonMutex;
    tbvMutexT spi4StatMonMutex;

    // the recording fiber is needed to avoid using the parent task fiber
    tbvFiberT spi4CtlDatMonFiber;
    tbvFiberT spi4CtlMonFiber;

    //tasks associated with spi4IfMonTvm tvm
    spi4CtlDatMonTaskT spi4CtlDatMon;
    spi4CtlMonTaskT spi4CtlMon;
    spi4StatMonTaskT spi4StatMon;

    // Event Expressions
    tbvEventExprT posedge_sclk;
    tbvEventExprT anyedge_dclk;
    tbvEventExprT ctl_1;
    tbvEventExprT stat_3;


    unsigned int cal_len;
    unsigned int cal_m;

    void setCal_len(unsigned int k){cal_len = k;}
    void setCal_m(unsigned int k){cal_m = k;}
  

   // This function is called from $tbv_tvm_connect, to Create a TVM object.
    static void create ( );


};



