// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

/* ATM control word foramt is as follows: 
       0                   1                   2                   3
       0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |  Res  |T|E|C|U|Res|  Length   |   Sequence Number (Optional)  |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                              "                                |
      |                     ATM cell or AAL5 CPCS-SDU                 |
      |                              "                                |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


Implementaion of vector controlWord is as follows:


       controlWord[3]  controlWord[2]  controlWord[1]  controlWord[0]
       --------------   -------------  --------------  --------------
       3               2               1               0
       7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0 
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |  Res  |T|E|C|U|Res|  Length   |   Sequence Number (Optional)  |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                              "                                |
      |                     ATM cell or AAL5 CPCS-SDU                 |
      |                              "                                |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
                  
                  
T = TranportType;
E = EFCI;
C = CLP;
U = Command/Response;

*/
#include "tbvATOMControlWord.h"

void rcs_tbvATOMControlWord_cc() { tbvOut << "$Id:$" << endl; }

/**************************************************************************/
tbvATOMControlWordT::tbvATOMControlWordT(const char * nameP = NULL):
                     tbvSmartRecordT(nameP),
		     controlWord(4,0)
{
  setup();
} 


/**************************************************************************/
tbvATOMControlWordT::tbvATOMControlWordT(const vector<uint8> controlWord, const char * nameP = NULL):
		     tbvSmartRecordT(nameP),
		     controlWord(4,0) 
{
  setup();
  setControlWord(controlWord);
} 


/**************************************************************************/
tbvATOMControlWordT::tbvATOMControlWordT(const tbvATOMControlWordT & rhs, 
			 const char * nameP = NULL):
			tbvSmartRecordT(nameP) 
{
  operator=(rhs);
} 


/**************************************************************************/
tbvATOMControlWordT & tbvATOMControlWordT::operator=(const tbvATOMControlWordT & rhs)
{
    tbvSmartRecordT::operator=(rhs);
    controlWord = rhs.getControlWord();
    return *this;
}


/**************************************************************************/
tbvATOMControlWordT * tbvATOMControlWordT::duplicate(const char * nameP = NULL) const
{
  return new tbvATOMControlWordT(*this, nameP);
}


/**************************************************************************/
tbvATOMControlWordT::~tbvATOMControlWordT() { wrapup(); }


/**************************************************************************/
void tbvATOMControlWordT::setup() { 
}


/**************************************************************************/

void tbvATOMControlWordT::wrapup() { } 

/**************************************************************************/

void tbvATOMControlWordT::setTransportType(unsigned int T){
  // reset T bit in control word and set with T
  controlWord[3] = (controlWord[3]&0xF7) | (T<<3);
}

/**************************************************************************/

void tbvATOMControlWordT::setEFCI(unsigned int E){
  // reset E bit in control word and set with E 
  controlWord[3] = (controlWord[3] & 0xFB) | (E<<2);
}

/**************************************************************************/

void tbvATOMControlWordT::setCLP(unsigned int C){
  // reset C bit in control word and set with C 
  controlWord[3] = (controlWord[3] & 0xFD) | (C<<1);
}

/**************************************************************************/

void tbvATOMControlWordT::setCommandResponse(unsigned int U){
  // reset T bit in control word and set with U 
  controlWord[3] = (controlWord[3] & 0xFE) | (U);
}

/**************************************************************************/

void tbvATOMControlWordT::setLength(unsigned int L){
  //reset lentgh field in control word and set with L
  controlWord[2] = controlWord[2] & 0x0 | L;
}

/**************************************************************************/

void tbvATOMControlWordT::setSequenceNumber(unsigned int SN){
  //reset SN field in control word and set with SN
  controlWord[1] = (controlWord[1] & 0x0) |(SN>>8);
  controlWord[0] = (controlWord[0] & 0x0) | (SN & 0x00ff);
}

/**************************************************************************/

void tbvATOMControlWordT::setControlWord(vector<uint8> CW){
controlWord = CW;
}

/**************************************************************************/

const vector<uint8> tbvATOMControlWordT::getControlWord() const{
  return controlWord;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getTranportType() const{

  unsigned int data = 0;
  data = (controlWord[3] & 0x08)>>3;
  return data;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getEFCI() const{
  unsigned int data = 0;
  data = (controlWord[3] & 0x04)>>2;
  return data;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getCLP() const{
  unsigned int data = 0;
  data = (controlWord[3] & 0x02) >> 1;
  return data;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getCommandResponse() const{
  unsigned int data = 0;
  data  = (controlWord[3] & 0x01);
  return data;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getLength() const{
  unsigned int data = 0;
  data = (controlWord[2] & 0x3f);
  return data;
}

/**************************************************************************/

const unsigned int tbvATOMControlWordT::getSequenceNumber() const{
  unsigned int data = 0;
  data = (controlWord[1] << 8) | controlWord[0];
  return data;
}

/**************************************************************************/

