// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_DATACOM_H 
#define TBV_DATACOM_H

#include "TestBuilder.h"
#include "math.h"
#include "strings.h"
#include "stdlib.h"
#include <memory>
#include "tbvControlData.h"
#include "tbvMPLS.h"
#include <unistd.h>
#include <sys/resource.h>
#include <iomanip.h>
#include "tbvDebug.h"
#include "macros.h"



class tbvDataComT : public tbvSmartRecordT {
public:
  //
  // constructors
  //
  tbvDataComT(const char * nameP = NULL);
  tbvDataComT(int size, const tbvControlDataT * controlP = NULL, 
	      const char * nameP = NULL);
  tbvDataComT(const char * payload, int sz, const tbvControlDataT * controlP = NULL, 
  	      const char * nameP = NULL);
  tbvDataComT(const vector<uint8> & payload, 
	      const tbvControlDataT * controlP = NULL, 
  	      const char * nameP = NULL);

  //copy constructor
  tbvDataComT(const tbvDataComT & rhs, 
 	      const char* nameP = NULL);

  //field constructor
  tbvDataComT(const tbvSmartDataT * parentP, const char* nameP = NULL,
              bool derived = false);

  //destructor
  virtual ~tbvDataComT();

  //assignment operator
  tbvDataComT & operator=(const tbvDataComT & rhs);

  //duplicate function
  virtual tbvDataComT * duplicate(const char* nameP = NULL) const;
  virtual tbvDataComT * duplicate(const tbvSmartDataT * parentP,
				  const char* nameP = NULL,
  				  bool derived = false ) const;
  // data access methods
  int 			getSize() const;
				// returns the size of the DataComT
				// including header & payload & trailer & pad
  int 			getPayloadSize() const;
				// returns the size of payload (include pad) of the DataComT
  void 			setHeaderSize(const unsigned int);
                                // explicitly set header size
  unsigned int  	getHeaderSize() const;
                                // get header size
  void                  setTrailerSize(const unsigned int trailerSize);
				//set trailer size
  int 			getTrailerSize() const;
           			//get trailer size
  virtual void                  setHeader(const vector<uint8> & header){};
  virtual void                          setHeader(const char * headerP, int sz){};
  virtual void			setTrailer(const vector<uint8> & trailer){};

//getData should be returning pad too.
  virtual vector<uint8> 	getData() const;
				// returns the whole data including header&payload&trailer
  virtual vector<uint8> 	getHeader() const;
				// returns the header data
  virtual vector<uint8> 	getPayload() const;
				// returns the payload data
  virtual vector<uint8> 	getTrailer() const;
				// returns the trailer data
                                //inherited class implements
  virtual void			setPayload(const char * payload, int sz);
				// set the payload to the input string
  virtual void 			setPayload(const vector<uint8> & payload);
				// set the payload to the input string
  virtual void			insertBytes(const unsigned int start_index, const vector<uint8> & bytes);
				// insert the bytes to the payload starting at start_index
  virtual vector<uint16> 	getDataBy16() const;
				// get the whole data in vector of 16 bits
				// this is used to serilize the data to write on the databus
  virtual vector<uint32>	getDataBy32() const; 
				// get the whole data in vector of 64 bits
				// this is used to serilize the data to write on the databus
  virtual vector<uint64>	getDataBy64() const; 
				// get the whole data in vector of 64 bits
				// this is used to serilize the data to write on the databus
  bool				isPkt() const;
				// check to see if it is a packet
  bool				isCell() const;
				// check to see if it is a cell

  // control data access methods
  virtual DATACOM_TYPE			getType();
  const tbvControlDataT & 		getControlData() const;
  void  				setControlData(const tbvControlDataT & control);
  virtual void				setInputPort(const unsigned int);
  virtual const tbvSmartUnsignedT &		getInputPort() const;
  virtual void    		setOutputPort(const unsigned int);
  virtual const tbvSmartUnsignedT &		getOutputPort() const;
  virtual void    		setQos(const unsigned int);
  virtual const tbvSmartUnsignedT &		getQos() const;
				//return a reference of the qos of the DataComT
  virtual void    		setFid(const tbvFlowIdT &);
  virtual const tbvFlowIdT &		getFid() const;
				//return a reference of the flow id of the DataComT
  virtual void                  setBidList(const tbvListT<tbvSmartUnsignedT>&);
  virtual const tbvListT<tbvSmartUnsignedT>& getBidList() const;
 virtual void                  setBid(const unsigned int bid);
 virtual const tbvSmartUnsignedT&  getBid() const;
                               // return a refernce to the List of BIDs of the DataCom


  virtual void    		setTrafficType(const unsigned int);
  virtual const tbvSmartUnsignedT &		getTrafficType() const;
				//return a reference of the traffic type of the DataComT
  virtual void    		setSN(const unsigned int);
  virtual const tbvSmartUnsignedT &		getSN() const;
				//return a reference of the sequence number of the DataComT
  virtual const unsigned int   getMPLSCount() const;
				//return the reference of the MPLS_Count indicator in the DataComT
  virtual void    		setSOP(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getSOP() const;
				//return the reference of the start of packet indicator in the DataComT
  virtual void    		setEOP(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getEOP() const;
				//return the reference of the end of packet indicator in the DataComT
  virtual void    		setSOB(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getSOB() const;
				//return the reference of the start of burst indicator in the DataComT
  virtual void    		setEOB(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getEOB() const;
				//return the reference of the end of burst indicator in the DataComT
  virtual void    		setCLP(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getCLP() const;
				//return the reference of cell loss priority in the DataComT
  virtual void    		setEFCI(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getEFCI() const;
				//return the reference of early forwarding congestion indicator in the DataComT
  virtual void    		setValid(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getValid() const;
				//return the reference of the validation indicator of the DataComT
  virtual void    				setBad(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getBad() const;
				//return the reference of the bad data indicator of the DataComT
  virtual void    				setOAM(const unsigned int);
  virtual const tbvSmartUnsignedT & 		getOAM() const;
				//return the reference of the OAM indicator of the DataComT
  void    					setArriveTime(const uint64 time);
  const uint64 		 			getArriveTime() const;
				//return the datacom arrive time 
  void    					setDepartureTime(const uint64 time);
  const uint64 		 			getDepartureTime() const;
				//return the datacom departure time 
  void    					setTransactionHandle(const tbvTransactionHandleT & handle);
  const tbvTransactionHandleT			getTransactionHandle() const;
				//return the datacom transaction handle
  bool 				isControlEqual(const tbvDataComT & datacom,
					       tbvListT<CONTROL_FIELD_TYPE> & fields,
					       bool keep = false, 
					       bool error = TRUE,
					       tbvFiberT * fiberP = NULL) const;
				//compare the fields between two control
                                //data depend on the fields listed in the 
                                //second arguments. If keep is true, compare
                                //all the fields in the list. If keep is
                                //false, compare all the fields not in the 
                                //list.
	
  // MPLS access methods
  void 			popMPLS();
				//remove the first mpls tag from the mpls queue
  void			pushMPLS(const tbvMPLST & mpls);
				//push the mpls tag into the mpls queue
  tbvMPLST 		frontMPLS() const;
				//return the refrence of the first mpls tag from the mpls queue 
  tbvMPLST             frontMPLS1() const;
				//return the refrence of the second mpls tag from the mpls queue
  tbvMPLST             frontMPLS2() const;
                                //return the refrence of the third mpls tag from the mpls queue

  bool			isMPLS() const;
				//return true if the DataComT is MPLS type
  // Key extraction (for look-up engine)
  virtual unsigned long long  getKey() const;
 
  // override the randomize method so the payload can be generated randomly
  virtual void		randomize();
  virtual void		randomData();
  virtual void 		randomPayload(int sz = 0);
				//randomize the payload data
				//the payload has fixed size sz
  virtual void 		randomHeader() { }
				//randomize the header data
  virtual void 		randomTrailer() { }
				//randomize the trailer data

  // function called to convert another type of tbvDataComT to this type
  void 			convertFrom(const tbvDataComT * rhsP, 
				    PROTOCOL_LEVEL dir = EQUAL, 
				    const vector<uint8> * headerP = NULL,
				    const vector<uint8> * payloadP = NULL,
				    const vector<uint8> * trailerP = NULL);

protected:

  // these mothods are used for switching between different derived cells.
  // these mothods are also used for switching between different derived packets. 

  virtual void 		createHeader(const vector<uint8> & header);
				//this function should always be override by the derived 
				//class to extract its specifical header format
  virtual void		createPayload(const vector<uint8> & payload);
				//this function should always be override by the derived 
				//class to extract its specifical payload
  virtual void		createTrailer(const vector<uint8> & data);
				//this function should always be override by the derived 
				//class to extract its specifical trailer

  // attributes
  int			_htsize;
				//the size of header of DataComT
  int                   _trailerSize; 
                                //the size of the trailer in bytes
  tbvSmartUnsignedT		_payloadsize;
				//the size of the payload ( include pad) of the DataComT
  vector<uint8>  	_payload;
				//the payload of the DataComT
  tbvControlDataT	_control;
				//the control data with DataComT
  bool 			_isPkt;
 				// true if it is a packet
  bool 			_isCell;
				// true if it is a cell  
  virtual void  setMPLSCount(const unsigned int mpls_count);
private:

  void 			setup();
  void			wrapup();

public:
  friend    ostream& operator<<(ostream& ostr, const tbvDataComT &x);
  friend    istream& operator>>(istream& istr, tbvDataComT &x);
  void setValidFields(tbvListT<CONTROL_FIELD_TYPE> & fields);
  tbvListT<CONTROL_FIELD_TYPE> getValidFields() const ;

};  

typedef tbvDataComT * tbvDataComPtrT;

ostream& printDatacom(ostream& ostr, const tbvDataComT &x);
#endif // class tbvDataComT

