// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef MONITOR_TASK_H 
#define MONITOR_TASK_H

#include <fstream.h>
#include <set>
#include "TestBuilder.h"
#include "tbvCell.h"
class tbvMonitorTaskT : public tbvTaskTypeSafeT<tbvCellT> {
 public:
  tbvMonitorTaskT(tbvTvmT *tvm,tbvSignalHdlT  & _clk, tbvSignalHdlT  & _reset, char *nameP) : 
    tbvTaskTypeSafeT<tbvCellT>(tvm, nameP),
    monitorFiber(tvm,nameP),
    clk(& _clk),
    reset(& _reset),
    inputStream(),
    outputStream(),
    readInput(false),
    writeOutput(false), 
    posEdgeClk ( (*clk), tbvThreadT::POSEDGE ),
    notReset ( (*reset), 1 ) {
  }

    vector <uint8> readBus(tbvSignalHdlT &data, tbvSignalHdlT &clk, 
                           tbvSignalHdlT &eob, tbvSignalHdlT *byte_enableP = NULL) ;
    vector <uint8> getByteEnable(tbvSignalHdlT *byte_enableP);
    virtual tbvDataComT * allocate() = 0;
    tbvSignalHdlT & getClk();
    void setInputFile(char *filename);
    void setOutputFile(char *filename);
    void readCell(tbvDataComPtrT x);
    void writeCell(tbvDataComPtrT x);
    virtual void body(tbvCellT *cellPtr);
    virtual void monitorBody(tbvCellT *cellPtr) {}
    virtual void disableException(const char *exceptionString);
    virtual void disableException();
    virtual void restoreException(const char *exceptionString);
    virtual void restoreException();
    virtual void disableExitOnException(const char *exceptionString);
    virtual void disableExitOnException();
    virtual void restoreExitOnException(const char *exceptionString);
    virtual void restoreExitOnException();
    virtual void setUserExceptionTypeString(const char *exceptionString);
    virtual void reportUserException( const char *exceptionString,
				      tbvExceptionT::severityLevelT sevLevel,
				      const char *messageString);
    tbvFiberT monitorFiber;
private:
   tbvSignalHdlT * clk;
   tbvSignalHdlT * reset;
   set<string> exceptionDisable;
   bool exceptionDisableAll;
   set<string> exceptionExitDisable;
   bool exceptionExitDisableAll;
  public:
   ifstream inputStream;
   ofstream outputStream;
   bool readInput;
   bool writeOutput;

   tbvEventExprT posEdgeClk;
   tbvEventExprT notReset;
};

#endif
