// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_SAR_H 
#define TBV_SAR_H

#include "tbvCell.h"
#include "tbvPkt.h"
#include "crcFunctions.h"
#include "tbvATMCell.h"
#include "tbvSwitchCell.h"
#include "tbvSwitchPkt.h"
#include "tbvIngressSwitchHeader.h"
#include "tbvINTCell.h"

class tbvSarT {
public:

  //segmentation functions
   static tbvPriorityListT<tbvCellT> *    tbvPktToCell(tbvPktT  &pkt,
                                                     tbvSmartUnsignedT & sizeCell);
   static tbvPriorityListT<tbvCellT> *    tbvPktToCell(tbvPktT  &pkt,
                                                    unsigned int sizeCell);
                                                    

static tbvPriorityListT<tbvCellT> * 	tbvPktToAAL5Cell(tbvPktT  &pkt, tbvCellT* cellPrototype);
static tbvPriorityListT<tbvCellT> * 	tbvPktToAAL5Cell(tbvPktT  &pkt, tbvCellT* cellPrototype, unsigned aal5Length, bool crc32Error = false);
static tbvPriorityListT<tbvCellT> * 	tbvPktToAAL5ATMCell(tbvPktT  &pkt, tbvATMCellT* cellPrototype); 


static tbvPriorityListT<tbvCellT> * tbvSwitchPktToCell (tbvSwitchPktT &packet, unsigned int size);
static tbvPriorityListT<tbvCellT> * tbvSwitchCellToCell (tbvPriorityListT<tbvCellT> * sw_cell_list,tbvSwitchCellT* switchcellPrototype);

  //reassembly functions

  static tbvPktT			tbvCellToPkt(tbvPriorityListT<tbvCellT> * cells,
						     const char * nameP = NULL);

  //priority function ptr
  static int SNPriority(const tbvCellT & a, const tbvCellT & b);  

//private:


static  tbvPriorityListT<tbvCellT> *		addAAL5Trailer(tbvPriorityListT<tbvCellT> *,unsigned int sizeCell);
static  tbvPriorityListT<tbvCellT> *		addAAL5Trailer(tbvPriorityListT<tbvCellT> *,unsigned int sizeCell, int aal5Length, bool crc32Error = false);
static  tbvPriorityListT<tbvCellT> 		removeAAL5Trailer(tbvPriorityListT<tbvCellT> &);


};  


#endif // class tbvSarT
