// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.
//
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM.
// ----------------------------------------------------------------------------

#ifndef TBV_SWITCHPKT_H 
#define TBV_SWITCHPKT_H

#include "tbvPkt.h"


class tbvSwitchPktT : public tbvPktT {
public:
  //
  // constructors
  //
  tbvSwitchPktT(int size, const tbvControlDataT * controlP = NULL,
		 const char * nameP = NULL);
  tbvSwitchPktT(const vector<uint8> & payload,
                 const tbvControlDataT * controlP = NULL,
                 const char * nameP = NULL);
  tbvSwitchPktT(const char * payloadP, int sz,
                 const tbvControlDataT * controlP = NULL,
                 const char * nameP = NULL);
  tbvSwitchPktT(const vector<uint8> & header, 
	         const vector<uint8> & payload,
                 const tbvControlDataT * controlP = NULL,
                 const char * nameP = NULL);
  tbvSwitchPktT(const char * headerP,  int hsz,
	         const char * payloadP, int psz, 
                 const tbvControlDataT * controlP = NULL,
                 const char * nameP = NULL);

  //copy constructor
  tbvSwitchPktT(const tbvSwitchPktT & rhs,
		 const char * nameP = NULL);

  tbvSwitchPktT(const tbvPktT & rhs,
		 const char * nameP = NULL);
  //destructor
  virtual ~tbvSwitchPktT();

  //field constructor
  tbvSwitchPktT(const tbvSmartDataT * parentP, const char * nameP = NULL,
		 bool derived = false);

  //assign operator
  tbvSwitchPktT & operator=(const tbvSwitchPktT & rhs);

  //duplicate functions
  virtual tbvSwitchPktT * duplicate(const char* nameP = NULL) const;
  virtual tbvSwitchPktT * duplicate(const tbvSmartDataT * parentP,
				     const char * nameP = NULL,
				     bool derived = false ) const;

  // access functions
  virtual vector<uint8> 		getHeader() const;
					//get the header of the Pkt 
  void				setHeader(const vector<uint8> & header);
  void				setHeader(const char * headerP, int sz);
  virtual DATACOM_TYPE		getType();
  virtual void 		randomPayload(int sz = 0);
  virtual const unsigned int getMPLSCount() const;
protected:

  virtual void		createHeader(const vector<uint8> & data);
				//create header from a stream of data
				//according to the format
  virtual void		createPayload(const vector<uint8> & data);
				//create payload from a stream of data
				//according to the format
  

private:
 
  vector<uint8>		_header;

  void 			setup();
  void			wrapup();

};  


#endif // class tbvSwitchPktT
