// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "reassemblyChecker.h"

reassemblyCheckerT::reassemblyCheckerT():

    topCheckerT ("reassembly"),
    mismatches(0)

{}

void reassemblyCheckerT::processInput(dataGramT * dataGramP) {
    debugOutput() << "called reassemblyCheckerT::processInput" << endl;
    inputFromMonitor.push(dataGramP);    
}
    
void reassemblyCheckerT::processOutput(dataGramT * dataGramP) {
    debugOutput() << "called reassemblyCheckerT::processOutput" << endl;

    // until real cells are passed through
    fakeOutputCellForTesting(dataGramP);

    // else
    // outputFromMonitor.push(dataGramP);    

}

void reassemblyCheckerT::fakeOutputCellForTesting(dataGramT * dataGramP) {
    vector<uint8> fakeData = dataGramP->getDataComP()->getDataAsBytes();
    fakeData.resize(52);
    dataPayloadT *fakePayload = new dataPayloadT(fakeData);
    dataGramT *fakeDataGramP = new dataGramT(fakePayload, dataGramP->getSidebandControlP()->duplicate());

    outputFromMonitor.push(fakeDataGramP);    
    cellsToCheck.post();
    delete dataGramP;
}


bool reassemblyCheckerT::compare(dataGramT * expectDatacomP, dataGramT * actualDatacomP) {
    dataComT *expect = expectDatacomP->getDataComP();
    dataComT *actual = actualDatacomP->getDataComP();
    if (expect->getDataAsBytes() == actual->getDataAsBytes()) {
        return true;
    } else {
        debugOutput() << "expected: " << *expect << endl;
        debugOutput() << "actual: " << *actual << endl;
        return false;
    }
}

void reassemblyCheckerT::body() {

    cellsToCheck.wait();
    debugOutput() << "called reassemblyCheckerT::body with cell to check" << endl;

    // extremely simple implementation, will break later
    transform.type0(inputFromMonitor,expectedFromChecker);

    dataGramT *actual = outputFromMonitor.front();
    dataGramT *expected = expectedFromChecker.front();
    if (!compare(expected, actual)) {
        mismatches++;
    }

    outputFromMonitor.pop();
    expectedFromChecker.pop();
    delete actual;
    delete expected;
}

