// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef TBV_RASCHECKER_H 
#define TBV_RASCHECKER_H
#include "common/topChecker.h"
#include "reassemblyTransform.h"

class reassemblyCheckerT : public topCheckerT {
  public:
    //
    // constructors
    //
    reassemblyCheckerT();
    virtual ~reassemblyCheckerT() { }

    // data access methods

    virtual void processInput(dataGramT * dataGramP);
    virtual void processOutput(dataGramT * dataGramP);
    virtual bool compare(dataGramT * expectDatacomP, dataGramT * actualDatacomP);
    void body();
    unsigned mismatches;

  private:
    reassemblyTransformT transform;

    // single queues for now, will expand later
    reassemblyInputQueue inputFromMonitor;
    reassemblyOutputQueue outputFromMonitor;
    reassemblyOutputQueue expectedFromChecker;

    tbvSemT cellsToCheck;

    void fakeOutputCellForTesting(dataGramT * dataGramP);

}; 

#endif
