// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "dataGram.h"

dataGramT::dataGramT(const char * nameP) :
  sidebandControl(NULL),
  dataComP(NULL)
{
  setup();
}

dataGramT::dataGramT(dataComT * dataCom,
		     sidebandControlT * sideband,const char * nameP) :
  sidebandControl(sideband),
  dataComP(dataCom){
  setup();
}

/*********************************************************************************************/
dataGramT::~dataGramT(){
  if(sidebandControl != NULL)
    delete sidebandControl;
  if(dataComP != NULL)
    dataComP->deleteAll();
}

/*********************************************************************************************/

sidebandControlT * dataGramT::getSidebandControlP() const {
  if(sidebandControl == NULL)
    cout<<"ERROR:sidebandControl is NULL"<<endl;
  return sidebandControl;
}

/*********************************************************************************************/

void dataGramT::setSidebandControlP(sidebandControlT * _control){
  sidebandControl = _control;
}

/*********************************************************************************************/
unsigned int dataGramT::getDataSize(){
  // inherited class must return data size if dataCom is present
  return 0;
}
/*********************************************************************************************/
dataComT * dataGramT::getDataComP() const {
  return dataComP;
}

/*********************************************************************************************/
void dataGramT::setDataComP(dataComT * data){
  dataComP = data;
}

/*********************************************************************************************/
void dataGramT::setup(){

}
