// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef DATA_PAYLOAD_H
#define DATA_PAYLOAD_H

#include "dataCom.h"
#include "macros.h"
//#include "TestBuilder.h"
#include <stl.h>
/** Inherits from dataComT, has a place holder for payload */

class dataPayloadT : public dataComT {       
 public:
  dataPayloadT(const char * nameP = NULL);
  dataPayloadT(unsigned size,const char * nameP = NULL);
  dataPayloadT(vector<uint8> x,const char * nameP = NULL);
  dataPayloadT& operator=(const dataPayloadT &rhs);
  dataPayloadT * duplicate();
  ~dataPayloadT();
  
  void selfExtract();
  dataComPtr extract();
  void randomPayload();
  ostream& printDataCom(ostream &ostr) const;
 protected:
  vector<uint8> getPayloadAsBytes() const;
  vector<uint8> getHeaderAsBytes() const;
  vector<uint8> getTrailerAsBytes() const;
  
  void setPayloadAsBytes(const vector<uint8> &payload);
  void setHeaderAsBytes (const vector<uint8> &header);
  void setTrailerAsBytes(const vector<uint8> &trailer);
  
 private:
  vector<uint8> payload;
  dataPayloadT(const dataPayloadT &rhs);
  ostream& printHeader(ostream &ostr) const {return ostr;}
  ostream& printTrailer(ostream &ostr) const {return ostr;}
};

#endif
