// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "message.h"

messageT::messageT(const char * nameP):
  tbvSmartRecordT(nameP),
  data(NULL){
  setup();
}

void messageT::setMessage(messageType msg){
  message = msg;
}

messageT::~messageT(){
  wrapup();
}
void messageT::setData(tbvSmartDataT * data){
  // duplicate data, B'se caller is responsible for deleting pointers owned by him.
  // Basically do not tranfers the ownership.
  this->data = data->duplicate();
}



tbvSmartDataT * messageT::getData(){
  return data;
}

const int messageT::getMessage(){
  return message;
}
void messageT::setUserMessageString(string msg){
  userMessageString = msg;
}

string messageT::getUserMessageString(){
  return userMessageString;
}

void messageT::setSeverityLevel(severityLevel sev){
  severity = sev;
}

const int messageT::getSeverityLevel(){
  return severity;
}
void messageT::setup(){
}

void messageT::wrapup(){
  if(data != NULL)
    delete data;
}
