// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MESSAGE_HANDLER_H
#define MESSAGE_HANDLER_H

#include "TestBuilder.h"
#include "message.h"

/** defgroup messagingStructure Message Handler
    This is absract base class for all type of message handling class.
    All message handling class must inherit from this class making
    them a spawnable.

*/
    
class messageHandlerT : public tbvTaskTypeSafeT<messageT> {
 public:
  messageHandlerT(const char *nameP = NULL);
  ~messageHandlerT(){}
  
 protected:
  /// The subclass may use this queue.(Most likely for further processing at later time).
  tbvMailboxT<messageT *> msgQueue;
  
  /// \param msg pointer to messageT.
  void pushMessage(messageT * msg);
  
  void popMessage(messageT * msg);
  
  //   virtual void body(messageT * msg){}
};

#endif
