// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MESSAGE_RESPONDER_H
#define MESSAGE_RESPONDER_H

#include "TestBuilder.h"
#include "message.h"
#include "messageHandler.h"
#include "backgroundTask.h"
/** \ingroup messagingStructure message responder
    This class responds to a message handling request and calls approprite
    messageHandler.

    The message handling requests are posted into a queue,and this task 
    waits on that q, gets the message(instance of messageT),looks for appropriate
    messageHandler(must be sub class of messageHandlerT) and call run on that
    message handler.Run must return in 0 time.

*/

class messageResponderT : public backgroundTaskT {
 public:
  messageResponderT(const char * nameP = NULL);
  ~messageResponderT();
  
  /// User reports messages using this function
  static void report(tbvSafeHandleT<messageT> msg);
  
  /// return reference to messageT
  static  tbvSafeHandleT<messageT> createMessage();

  /// register messages with messageHandler instance.
  /// When ever msg is caught run() will be called on msgHandler
  void registerMessageWithMessageHandler(messageT::messageType msg ,
					 messageHandlerT * msgHandler);
  void unregisterMessageWithMessageHandler(messageT::messageType msg);
  /// spawns this task
  //void start();

  /// kills the current thread
  //void stop();

 protected:
  void body();

 private:

  static tbvMailboxT<tbvSafeHandleT<messageT> > * messageQueue;
  map<messageT::messageType,messageHandlerT *> messageTypeToMessageHandler;
  
  void setup();
};

#endif


