// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "monitorTask.h"

monitorTaskT::monitorTaskT(tbvTvmT *tvm,tbvSignalHdlT  & _clk, 
			   const char *nameP) :
  backgroundTaskT(nameP),
  posEdgeClk ( _clk, tbvThreadT::POSEDGE ),
  monitorFiber(tvm, nameP),
  clk(& _clk),
  monitorQueue (getNameP(),1)
{
  setup();
}

/******************************************************************************************/
monitorTaskT::monitorTaskT(tbvTvmT *tvm,const char *nameP) :
    backgroundTaskT(nameP),
  monitorQueue (getNameP(),1){
}

/******************************************************************************************/

monitorTaskT::~monitorTaskT(){
}

/******************************************************************************************/
bool monitorTaskT::pushIntoMonitorQueue(dataGramT * dataGram){
  // The monitor Queue is having one space,logically at any time there should be space
  // for new entry.This function should check whether there is  space at the time this function is called
  //if not return false(That means cells are not dispatched to checker as soon as they are available.
  
  // Fix me ASAP.
  
  tbvEventExprT pushSuccessfull = monitorQueue.pushExpr();
  pushSuccessfull.wait(tbvEventExprT::IMMED);
  monitorQueue.push(dataGram);
  return true;
}
/******************************************************************************************/
dataGramT *monitorTaskT::popFromMonitorQueue(){
  dataGramT * dataGram;
  monitorQueue.pop(dataGram);
  return dataGram;
}

/******************************************************************************************/
tbvEventExprT  monitorTaskT::getPopEventExpr(){
  return (monitorQueue.popExpr());
}

/******************************************************************************************/
dataGramT * monitorTaskT::allocate(){
  return(new dataGramT());
  
}
/******************************************************************************************/
vector <uint8> monitorTaskT::readBus(tbvSignalHdlT &data, tbvSignalHdlT &clk,
					tbvSignalHdlT &eob, tbvSignalHdlT *byte_enableP) {
  unsigned int bitsInBus = data.msb()-data.lsb()+1;
  unsigned int bytesInBus = bitsInBus/8;
  vector <uint8> byte_en(bytesInBus,1);
  vector <uint8> celldata(80);
  unsigned int dataRead = 0;
  
  
  //wait while EOB is not set
  while (((eob.getValue()) != 1) && (dataRead < 72))
    {
      for (unsigned int i = 0; i < bytesInBus; i++)
	{
	  if (byte_en[i] == 1)
	    {
	      celldata[dataRead] = (data(bitsInBus -(8*i) - 1,
					 bitsInBus -(8*i) - 8).getValue());
	      dataRead++;
	    }
	  
	}
      tbvWaitCycle(clk, tbvThreadT::POSEDGE);
      
      
    }
  
  byte_en = getByteEnable(byte_enableP);
  for (unsigned int i = 0; i < bytesInBus; i++)
    {
      if (byte_en[i] == 1)
	{
	  celldata[dataRead] = (data(bitsInBus -(8*i) - 1,
				     bitsInBus -(8*i) - 8).getValue());
	  dataRead++;
	}
    }
  celldata.resize(dataRead);
  return celldata;
}

/******************************************************************************************/
vector<uint8> monitorTaskT::getByteEnable(tbvSignalHdlT *byte_enableP) {
  vector<uint8> byte_en(8,1);
  if(byte_enableP)
    switch ((byte_enableP->getValue())){
    case 0 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
      byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 1;byte_en[7] = 1; break;
    case 1 : byte_en[0] = 1;byte_en[1] = 0;byte_en[2] = 0;byte_en[3] = 0;
      byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
    case 2 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 0;byte_en[3] = 0;
      byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
    case 3 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 0;
      byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
    case 4 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
      byte_en[4] = 0;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
    case 5 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
      byte_en[4] = 1;byte_en[5] = 0;byte_en[6] = 0;byte_en[7] = 0; break;
    case 6 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
      byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 0;byte_en[7] = 0; break;
    case 7 : byte_en[0] = 1;byte_en[1] = 1;byte_en[2] = 1;byte_en[3] = 1;
      byte_en[4] = 1;byte_en[5] = 1;byte_en[6] = 1;byte_en[7] = 0; break;
    }
  return byte_en;
}

/******************************************************************************************/

tbvSignalHdlT & monitorTaskT::getClk(){
  return * clk;
}

/******************************************************************************************/
tbvFiberT & monitorTaskT::getFiber() {
  return monitorFiber;
}

/******************************************************************************************/
void monitorTaskT::setup(){

}

/******************************************************************************************/
void monitorTaskT::finish() {
  if ( monitorFiber.hasTransaction() )
    monitorFiber.endTransaction();
}
