// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MONITOR_TASK_H 
#define MONITOR_TASK_H

#include "TestBuilder.h"
#include "dataGram.h"
#include "backgroundTask.h"
#include "tvmAutoRegister.h"

/** \ingroup monitorDriver  base class for all monitors.
    Abstract base class for all monitor classes.
    Inherited class are expected to implement body() and allocate();
    Argument of the body() is typesafed to dataGramT * .
    This class takes  care recording transactions into fiber,starting and stoping of thread.
    
    In addition there is a monitorQueue(tbvMailbox), the data read by monitor must be pushed 
    this queue;
    
*/
class monitorTaskT : public backgroundTaskT {
 public:
  monitorTaskT(tbvTvmT *tvm,tbvSignalHdlT  & _clk,
	       const char *nameP = NULL);

  monitorTaskT(tbvTvmT *tvm,const char *nameP = NULL);
  virtual ~monitorTaskT();

  dataGramT * popFromMonitorQueue();
  tbvEventExprT getPopEventExpr();
  
  virtual void finish();
 protected:
  vector <uint8> readBus(tbvSignalHdlT &data, tbvSignalHdlT &clk,
			 tbvSignalHdlT &eob, tbvSignalHdlT *byte_enableP = NULL);
  
  vector <uint8> getByteEnable(tbvSignalHdlT *byte_enableP);
  bool pushIntoMonitorQueue(dataGramT * dataGram);
  dataGramT * allocate();
  tbvSignalHdlT & getClk();
  tbvFiberT & getFiber();
  tbvEventExprT posEdgeClk;

  bool running;
  
 private:
  tbvFiberT monitorFiber;
  tbvSignalHdlT * clk;
  tbvSignalHdlT * reset;
  tbvMailboxT<dataGramT *> monitorQueue;
  void setup();
};

#endif
