//****************************************************************
//
//     File Name :     memRasDriverTvm.v
//
//     Author    :      Leena Singh
//
//
//     Module Name:    memRasDriverTvm
//
//     Description:    Reasmbly block interface to be used for
//                     Test Builder verification environment 
//
//
//     History of changes :
//
//     Date :          
//
//     Change made :
//
//
//****************************************************************


module memRasDriverTvm(
                   reset_l,
                   clk,
                   gsync,

                   cpu_ras_cs_l,
                   cpu_rdwr_l,
                   cpu_addr,
                   cpu_data_in,

                   mem_ras_available,
                   mem_ras_cell_length,
                   mem_ras_cid,
                   mem_ras_clp,
                   mem_ras_data,
                   mem_ras_efci,
                   mem_ras_eof,
                   mem_ras_eop,
                   mem_ras_lfi_type,
                   mem_ras_mlppp_length,
			   			   
                   mem_ras_param,
                   mem_ras_portid,
                   mem_ras_qid,
                   mem_ras_sof,
                   mem_ras_sop,
                   mem_ras_tid,
                   mem_ras_tidqid,
                   mem_ras_type,

                   ras_in_en,
                   ras_out_en,
                   ras_mem_ctrl_pop,
                   ras_mem_data_pop,

		   ras_cpu_data_out,
                   ras_cpu_intr,

                   ras_epe_byte_en,
                   ras_epe_bytecnt,
                   ras_epe_bytecnt_adj,
                   ras_epe_cell,
                   ras_epe_cid,
                   ras_epe_crc32_err,
                   ras_epe_data,
                   ras_epe_eob,
                   ras_epe_eop,
                   ras_epe_aal5len_err,
                   ras_epe_mtu_err,
                   ras_epe_nonzero_cpi,
                   ras_epe_param,
                   ras_epe_packet,
                   ras_epe_portid,
                   ras_epe_qid,
                   ras_epe_sob,
                   ras_epe_sop,
                   ras_epe_tid,
                   ras_epe_tidqid,
                   ras_epe_type

      );

   input           reset_l;
   input           clk;
   input           gsync;     // global sync

   output           mem_ras_available;
   output [12:0]    mem_ras_cid;
   output [6:0]     mem_ras_cell_length;
   output 	    mem_ras_clp;
   output [127:0]   mem_ras_data;
   output           mem_ras_efci;
   output           mem_ras_eof;
   output           mem_ras_eop;
  
   output [1:0]     mem_ras_lfi_type;
   output [3:0]     mem_ras_mlppp_length;
   output [15:0]    mem_ras_param;  // incoming cell parameters (pass through)
   output [6:0]     mem_ras_portid; // incoming cell's port id
   output [19:0]    mem_ras_qid;    // incoming cell's queue id (pass through)
   output           mem_ras_sof;
   output           mem_ras_sop;   // start of packet
   output [18:0]    mem_ras_tid;   // tunnel id (pass through)
   output           mem_ras_tidqid;
   output [3:0]     mem_ras_type;   // cell type

   output           ras_in_en;
   output           ras_out_en;
  

   input          ras_cpu_intr;       // ras to cpu interrupt
   input [31:0]   ras_cpu_data_out;   // ras to cpu data
  
   input          ras_mem_ctrl_pop;   // ctrl pop is used for rest of epe ctrl
   input          ras_mem_data_pop;   // data pop is used with data & byte_en

   input          ras_epe_aal5len_err;// aal5 length error
     input [15:0]   ras_epe_byte_en;    // byte enables
   input [6:0]    ras_epe_bytecnt;    // bytecount for the specific cell
   input [6:0]    ras_epe_bytecnt_adj;
   input          ras_epe_cell;       // to STATS to incr # of cells
   input [12:0]   ras_epe_cid;        // channel id
   input          ras_epe_crc32_err;  // aal5 crc error
   input [127:0]  ras_epe_data;
   input          ras_epe_eob;        // end of burst
   input          ras_epe_eop;        // end of packet
     input          ras_epe_mtu_err;    // mtu error
   input          ras_epe_nonzero_cpi;// non-zero cpi to STATS
   input          ras_epe_packet;     // tells statistics to incr # of pkts
   input [15:0]   ras_epe_param;      // pass through params for
   input [6:0]    ras_epe_portid;     // port id
   input [19:0]   ras_epe_qid;        // queue id
   input          ras_epe_sob;        // start of burst
   input          ras_epe_sop;        // end of packet
   input [18:0]   ras_epe_tid;        // tunnel id
   input          ras_epe_tidqid;     // tunnel id or qid
   input [3:0]    ras_epe_type;
  

  
   input [5:0]     cpu_addr;
   input [31:0]    cpu_data_in;
   input           cpu_ras_cs_l;
   input           cpu_rdwr_l;


reg ras_pop;
 // These registers are driven from C++
   reg           mem_ras_available_o;
   reg [12:0]    mem_ras_cid_o;
   reg [6:0]     mem_ras_cell_length_o;
   reg           mem_ras_clp_o;
   reg [127:0]   mem_ras_data_o;
   reg           mem_ras_efci_o;
   reg           mem_ras_eof_o;
   reg           mem_ras_eop_o;
   reg [3:0]     mem_ras_lfi_mlppp_o;
   reg [15:0]    mem_ras_param_o;  
   reg [6:0]     mem_ras_portid_o; 
   reg [19:0]    mem_ras_qid_o;    
   reg           mem_ras_sof_o;
   reg           mem_ras_sop_o; 
   reg [18:0]    mem_ras_tid_o;
   reg           mem_ras_tidqid_o;
   reg [3:0]     mem_ras_type_o; 


 // These assignments create Verilog drivers for the C++ regs


   assign mem_ras_available   =     mem_ras_available_o;
   assign mem_ras_cid         =     mem_ras_cid_o;
   assign mem_ras_cell_length =     mem_ras_cell_length_o;
   assign mem_ras_clp         =     mem_ras_clp_o;
   assign mem_ras_data        =     mem_ras_data_o;
   assign mem_ras_efci        =     mem_ras_efci_o;
   assign mem_ras_eof         =     mem_ras_eof_o;
   assign mem_ras_eop         =     mem_ras_eop_o;
   assign mem_ras_lfi_mlppp   =     mem_ras_lfi_mlppp_o;
   assign mem_ras_param       =     mem_ras_param_o;
   assign mem_ras_portid      =     mem_ras_portid_o;
   assign mem_ras_qid         =     mem_ras_qid_o;
   assign mem_ras_sof         =     mem_ras_sof_o;
   assign mem_ras_sop         =     mem_ras_sop_o;
   assign mem_ras_tid         =     mem_ras_tid_o;
   assign mem_ras_tidqid      =     mem_ras_tidqid_o;
   assign mem_ras_type        =     mem_ras_type_o;

  //
  //  register every instance of this TVM to test builder
  //

initial
 begin

        mem_ras_available_o   = 0;
        mem_ras_cid_o         = 0;
        mem_ras_cell_length_o = 0;
        mem_ras_clp_o         = 0;
        mem_ras_data_o        = 0;
        mem_ras_efci_o        = 0;
        mem_ras_eof_o         = 0;
        mem_ras_eop_o         = 0;
        mem_ras_lfi_mlppp_o   = 0;
        mem_ras_param_o       = 0;
        mem_ras_portid_o      = 0;
        mem_ras_qid_o         = 0;
        mem_ras_sof_o         = 0;
        mem_ras_sop_o         = 0;
        mem_ras_tid_o         = 0;
        mem_ras_tidqid_o      = 0;
        mem_ras_type_o        = 0;

 end

  initial
    $tbv_tvm_connect;

endmodule
