// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "rasBlockDataGen.h"

reassemblyDataGenT::reassemblyDataGenT()
{
  setup();
}

/**************************************************************************************/

reassemblyDataGenT::~reassemblyDataGenT(){
}

/**************************************************************************************/

list<dataGramT *> * reassemblyDataGenT::getListOfCells(unsigned int fid){
  
  dataGramRefBagMutex.lock();
  tbvBagT<dataGramT *> &dataGramRefBag  = dataGramRefs[fid];
  dataGramT * dataGramRefP;
  dataGramRefP = dataGramRefBag.peekNext();
  dataGramRefBagMutex.unlock();
  dataGramRefP->getDataComP()->randomPayload();
  totalNoOfPacketsSent++;
 
  list<dataGramT *> * cells = new list<dataGramT *>();
  
  dataGramT * outputDataGram = new dataGramT();
  dataComT * dataCom = dataGramRefP->getDataComP();
  
  dataPayloadT * payload = new dataPayloadT(dataCom->getDataAsBytes());
  //duplicate control data
  sidebandControlT * sidebandControl = (dataGramRefP->getSidebandControlP()->duplicate());
  memRasSidebandControlT * rasSidebandControl = ((memRasSidebandControlT *) sidebandControl);
  
  outputDataGram->setDataComP(payload);
  outputDataGram->setSidebandControlP(rasSidebandControl);
  cells->push_back(outputDataGram);
  return cells;
}

/***************************************************************************************/
/// return false if setup failed.
bool reassemblyDataGenT::setupTraffic(memRasSidebandControlT * sidebandControl){
  bool success = true;
  
  switch(sidebandControl->mem_ras_type){
  case 0: {
    dataPayloadT * dataPayload = new dataPayloadT(64);
    dataGramT * dataGram = new dataGramT(dataPayload,sidebandControl,"memRasTraffic");
    connectGenerator(dataGram);
    break;
  }
  
  default:{
    success =  false;
    break;
  }
  
  }
  
  return success;
}

/****************************************************************************************/

void reassemblyDataGenT::connectGenerator(dataGramT * dataGram,
					      float perQidWeight,
					      float perPortWeight) {
  memRasSidebandControlT sidebandControl  = 
    *((memRasSidebandControlT *) dataGram->getSidebandControlP());
  
  getFlowMem().linkFidToPort(sidebandControl.mem_ras_qid, 
			     sidebandControl.mem_ras_portid,perQidWeight);
  getFlowMem().setPortParam(sidebandControl.mem_ras_portid,perPortWeight);
  addDataGramRef(dataGram,sidebandControl.mem_ras_qid);
}

/****************************************************************************************/
void reassemblyDataGenT::addDataGramRef(dataGramT * dataGramP,unsigned int qid,
					    unsigned int num){
  dataGramRefBagMutex.lock();
  memRasSidebandControlT sidebandControl  = 
    *((memRasSidebandControlT *) dataGramP->getSidebandControlP());
  dataGramRefs[qid].add(dataGramP, num);
  dataGramRefBagMutex.unlock();
}
/****************************************************************************************/
tbvBagT<dataGramT *> reassemblyDataGenT::getDataGramRef(unsigned int qid){
  return dataGramRefs[qid];
}
/****************************************************************************************/
void reassemblyDataGenT::removeDataGramRef(dataGramT * dataGramP,unsigned int qid){
  dataGramRefBagMutex.lock();
  memRasSidebandControlT sidebandControl  = 
    *((memRasSidebandControlT *) dataGramP->getSidebandControlP());
  unsigned int port = sidebandControl.mem_ras_portid;
  dataGramRefs[qid].resetPeek();
  dataGramT * peekP = dataGramRefs[qid].peekNext();
  unsigned int bagsize = dataGramRefs[qid].size();
  while(peekP != dataGramP && bagsize != 0) {
    peekP = dataGramRefs[qid].peekNext();
    bagsize--;
  }
  if(bagsize != 0) {
    dataGramRefs[qid].remove(TRUE);
  }
  dataGramRefs[qid].resetPeek();

  if(dataGramRefs[qid].empty()) {
    flowMemT & flowMem = getFlowMem();
    flowMem.delinkFidFromPort(qid,port);
  }
  dataGramRefBagMutex.unlock();

}
/****************************************************************************************/
bool reassemblyDataGenT::rotate(const dataGramT * dataGramP){
  // rotate traffic on port if dataGramP has eop.
  cout<<"from reassemblyDataGenT::rotate"<<endl;
  memRasSidebandControlT sidebandControl  = 
    *((memRasSidebandControlT *) dataGramP->getSidebandControlP());
  bool rotate = false;
  if(sidebandControl.mem_ras_eop == 1)
    rotate = true;
  
  return rotate;
}
/****************************************************************************************/
void reassemblyDataGenT::setup(){
}







