// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "memRasMonitor.h"

TVM_VERILOG_REGISTER(memRasMonitorTvmT::create , "memRasMonitorTvm" );

memRasMonitorTaskT::memRasMonitorTaskT(memRasMonitorTvmT & tvm, tbvSignalHdlT &_clk,
					       const char * nameP):
  monitorTaskT(&tvm,_clk,nameP),
  memRasInterface(tvm){
}


/****************************************************************************************************/
void memRasMonitorTaskT::body(){
  
  //Allocate new dataGramT pointer,(which has *dataPayloadT and *memRasSidebandControlT).
  //Populate memRasSidebandControlT members such as mem_ras_available, mem_ras_clp etc.
  //create dataPayloadT out of data on data bus(mem_ras_data),set *dataPayloadT and 
  // *memRasSidebandControlT in dataGramT and push into mail box.
  debugOutput() << dec << "ras monitor spawned @ time =  " << tbvGetInt64Time(TBV_NS) << endl;

  tbvSignalHdlT &clk = getClk();

    dataGramT * dataGram = allocate();
    memRasSidebandControlT * memRasSidebandSignal = 
      new memRasSidebandControlT("Mem to Ras side band control");
    dataPayloadT * dataPayload;
    
    while (tbv4StateNotEqual(memRasInterface.reset_l, 1)){
      tbvWaitCycle(clk, tbvThreadT::POSEDGE);
    }
    

    while (tbv4StateNotEqual(memRasInterface.mem_ras_available, 1)){
      tbvWaitCycle(clk, tbvThreadT::POSEDGE);
    }


    
    tbvWait(10, TBV_PS);
    
    memRasSidebandSignal->mem_ras_type = memRasInterface.mem_ras_type.getValue();
    debugOutput() << "type from ras mon: " << memRasSidebandSignal->mem_ras_type  << endl;
    
    //memRasSidebandSignal->setValid(1);There is no valid signal in mem to ras side band signal;
    // Is Ras input state mechine going to accept data which is not valid? If yes we need to set this.
    
    memRasSidebandSignal->mem_ras_sop = memRasInterface.mem_ras_sop.getValue();
    memRasSidebandSignal->mem_ras_portid = memRasInterface.mem_ras_portid.getValue();
    
    //get data into vector after reading from mem_ras_data bus ,and create dataPayloadT
    
    vector<uint8> data(64);// temporary, this must be actual data.
    
  int dataRead = 0;
//wait while all data is read
  while (dataRead < 48)
    {
            debugOutput() << dec << "@" << tbvGetInt64Time(TBV_NS) << ": Verilog data: MemRas " << memRasInterface.mem_ras_data << endl;

      for (int i = 0; i < 16; i++)
        {
          data[dataRead] = (memRasInterface.mem_ras_data((127 - 8*i) , (127 - 8*i) - 7).getValue());

          dataRead++;
        }
      tbvWaitCycle(clk, tbvThreadT::POSEDGE);
      tbvWaitCycle(clk, tbvThreadT::POSEDGE);
      tbvWait(10, TBV_PS);
    }

    debugOutput() << dec << "@" << tbvGetInt64Time(TBV_NS) << ": Verilog data: MemRas " << memRasInterface.mem_ras_data << endl;
  debugOutput() << "data now has size " << dec << data.size() << " dataread is " << dataRead<< hex
<< endl;

  for (int i = 0; i < 16; i++)
    {
      data[dataRead] = (memRasInterface.mem_ras_data((127 - 8*i) , (127 - 8*i) - 7).getValue());

      dataRead++;
    }
  data.resize(dataRead);
 

    dataPayload = new dataPayloadT(data);
    
    // now you have sideband control and data, bundle them is dataGram and push into mail box.
    
    dataGram->setDataComP(dataPayload);
    dataGram->setSidebandControlP(memRasSidebandSignal);

    debugOutput() << dec << "MON: data: @ time = " << tbvGetInt64Time(TBV_NS)  << "  " << *dataPayload << endl;

    tbvWaitCycle(clk, tbvThreadT::POSEDGE);
    tbvWaitCycle(clk, tbvThreadT::POSEDGE); 
    
    pushIntoMonitorQueue(dataGram);
    tbvThreadT::yield(); 
}


/****************************************************************************************************/
//                           Mem to Ras Tvm
/****************************************************************************************************/

memRasMonitorTvmT::memRasMonitorTvmT(const char * nameP) :
//  tbvTvmT(nameP),
  reset_l(getFullInterfaceHdlNameP("reset_l") ),
  clk(getFullInterfaceHdlNameP("clk") ),
  gsync(getFullInterfaceHdlNameP("gsync") ),
  mem_ras_available(getFullInterfaceHdlNameP("mem_ras_available") ),
  mem_ras_cell_length(getFullInterfaceHdlNameP("mem_ras_cell_length") ),
  mem_ras_cid(getFullInterfaceHdlNameP("mem_ras_cid") ),
  mem_ras_clp(getFullInterfaceHdlNameP("mem_ras_clp") ),
  mem_ras_data(getFullInterfaceHdlNameP("mem_ras_data") ),
  mem_ras_efci(getFullInterfaceHdlNameP("mem_ras_efci") ),
  mem_ras_eof(getFullInterfaceHdlNameP("mem_ras_eof") ),
  mem_ras_eop(getFullInterfaceHdlNameP("mem_ras_eop") ),
  mem_ras_lfi_type(getFullInterfaceHdlNameP("mem_ras_lfi_type") ),
  mem_ras_mlppp_length(getFullInterfaceHdlNameP("mem_ras_mlppp_length") ),
  mem_ras_param(getFullInterfaceHdlNameP("mem_ras_param") ),
  mem_ras_portid(getFullInterfaceHdlNameP("mem_ras_portid") ),
  mem_ras_qid(getFullInterfaceHdlNameP("mem_ras_qid") ),
  mem_ras_sof(getFullInterfaceHdlNameP("mem_ras_sof") ),
  mem_ras_sop(getFullInterfaceHdlNameP("mem_ras_sop") ),
  mem_ras_tid(getFullInterfaceHdlNameP("mem_ras_tid") ),
  mem_ras_tidqid(getFullInterfaceHdlNameP("mem_ras_tidqid") ),
  mem_ras_type(getFullInterfaceHdlNameP("mem_ras_type") ),

  ras_in_en(getFullInterfaceHdlNameP("ras_in_en") ),
  ras_out_en(getFullInterfaceHdlNameP("ras_out_en") ),
  
  ras_mem_ctrl_pop(getFullInterfaceHdlNameP("ras_mem_ctrl_pop") ),
  ras_mem_data_pop(getFullInterfaceHdlNameP("ras_mem_data_pop") ),

  memRasMonitorTask(* this, clk, "Mem Ras Monitor")
{
  
}

/****************************************************************************************************/
memRasMonitorTvmT::~memRasMonitorTvmT(){

}

/****************************************************************************************************/
void memRasMonitorTvmT::create(){
  new memRasMonitorTvmT();
}









