// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MEM_RAS_MONITOR
#define MEM_RAS_MONITOR

#include "TestBuilder.h"
#include "common/monitorTask.h"
#include "common/dataPayload.h"
#include "../sideband/memRasSidebandControl.h"
/** \ingroup monitorDriver  memory to ras interface monitor.
    This file has a tvm(to connect HDL signal) and atleast one task to monitor
    memory to ras interface.

    The memRasMonitorT is inherited from monitorTaskT, implements allocate(),
    and body().

    Every time when a interface specific condition is met(when transanction is complete)
    this task pushes that info. via a pointer to dataGramT( *dataGramT).

    Everytime a new pointer to a object dataGramT is allocated via allocate() function,deletion of 
    this pointer taken care by caller of this monitor.

*/

class memRasMonitorTvmT;

class memRasMonitorTaskT : public monitorTaskT {
 public:
  // The constructor must take tvm ref.
  memRasMonitorTaskT(memRasMonitorTvmT & tvm, tbvSignalHdlT &_clk, const char * nameP = NULL);
  virtual ~memRasMonitorTaskT(){}
 protected:
 private:
  void body();
  memRasMonitorTvmT & memRasInterface;
  
};



//memRasMonitorTvmT

/******************************************************************************************************/
class memRasMonitorTvmT : public tbvTvmT {
 public:
   memRasMonitorTvmT(const char * nameP = NULL);
   virtual ~memRasMonitorTvmT();
   
   // HDL signals at ras PE interface
   
   tbvSignalHdlT   reset_l;
   tbvSignalHdlT   clk;
   tbvSignalHdlT   gsync;
   
   tbvSignalHdlT   mem_ras_available;
   tbvSignalHdlT   mem_ras_cell_length;
   tbvSignalHdlT   mem_ras_cid;
   tbvSignalHdlT   mem_ras_clp;
   tbvSignalHdlT   mem_ras_data;
   tbvSignalHdlT   mem_ras_efci;
   tbvSignalHdlT   mem_ras_eof;
   tbvSignalHdlT   mem_ras_eop;
   tbvSignalHdlT   mem_ras_lfi_type;
   tbvSignalHdlT   mem_ras_mlppp_length;
   tbvSignalHdlT   mem_ras_param;
   tbvSignalHdlT   mem_ras_portid;
   tbvSignalHdlT   mem_ras_qid;
   tbvSignalHdlT   mem_ras_sof;
   tbvSignalHdlT   mem_ras_sop;
   tbvSignalHdlT   mem_ras_tid;
   tbvSignalHdlT   mem_ras_tidqid;
   tbvSignalHdlT   mem_ras_type;
   
   tbvSignalHdlT   ras_in_en;
   tbvSignalHdlT   ras_out_en;
   
   tbvSignalHdlT   ras_mem_ctrl_pop;
   tbvSignalHdlT   ras_mem_data_pop;
   
   // Tasks in memRasMonitorTvmT
   memRasMonitorTaskT memRasMonitorTask;

  // This function is called from $tbv_tvm_connect, to Create a TVM object.
     static void create ( );
 protected:
 private:
};
#endif
   

