// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#include "memRasSidebandControl.h"

memRasSidebandControlT::memRasSidebandControlT(const char * nameP) :
  sidebandControlT(nameP){
  
}

memRasSidebandControlT::memRasSidebandControlT(const sidebandControlT & rhs,
						       const char * nameP){
  operator=(rhs);
}

memRasSidebandControlT * memRasSidebandControlT::duplicate(){
  return new memRasSidebandControlT(*this);
}
/********************************************************************************************/
memRasSidebandControlT & memRasSidebandControlT::operator=(const memRasSidebandControlT & rhs){

  sidebandControlT::operator=(rhs);
  this->reset_l = rhs.reset_l;
  this->clk = rhs.clk;
  this->gsync = rhs.gsync;
  
  this->mem_ras_available = rhs.mem_ras_available;
  this->mem_ras_cell_length =  rhs.mem_ras_cell_length;
  this->mem_ras_cid = rhs.mem_ras_cid;
  this->mem_ras_clp = rhs.mem_ras_clp;
  this->mem_ras_data = rhs.mem_ras_data;
  this->mem_ras_efci = rhs.mem_ras_efci;
  this->mem_ras_eof = rhs.mem_ras_eof;
  this->mem_ras_eop = rhs.mem_ras_eop;
  this->mem_ras_lfi_type = rhs.mem_ras_lfi_type;
  this->mem_ras_mlppp_length = rhs.mem_ras_mlppp_length;
  this->mem_ras_param =  rhs.mem_ras_param;
  this->mem_ras_portid = rhs.mem_ras_portid;
  this->mem_ras_qid = rhs.mem_ras_qid;
  this->mem_ras_sof = rhs.mem_ras_sof;
  this->mem_ras_sop = rhs.mem_ras_sop;
  this->mem_ras_tid = rhs.mem_ras_tid;
  this->mem_ras_tidqid = rhs.mem_ras_tidqid;
  this->mem_ras_type = rhs.mem_ras_type;

  this->ras_in_en = rhs.ras_in_en;
  this->ras_out_en = rhs.ras_out_en;

  this->ras_mem_ctrl_pop = rhs.ras_mem_ctrl_pop;
  this->ras_mem_data_pop = rhs.ras_mem_data_pop;
  return *this;
}

/***************************************************************************************************/
memRasSidebandControlT::~memRasSidebandControlT(){

  //clean up any memory allocated

}

/***************************************************************************************************/

