// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef MEM_RAS_SIDEBAND_CONTROL_H
#define MEM_RAS_SIDEBAND_CONTROL_H

#include "common/controlData.h"
#include "common/dataGram.h"

/** \ingroup control side band control signals for reassembly.
    This class inherits from sidebandControlT and implements
    reassembly(mem->ras) specific side band signal.

    RAS input monitors/drivers and checker(what not) updates(sets its variables) instance of this class.
    Instance of this class will be bundled in instance dataGramT and test bench's interblock communication
    will be through instance of dataGramT.

    

*/


class memRasSidebandControlT : public sidebandControlT {
 public:
  memRasSidebandControlT(const char * nameP = NULL);
  ~memRasSidebandControlT();

  virtual memRasSidebandControlT * duplicate();
  memRasSidebandControlT & operator=(const memRasSidebandControlT & rhs);
  // Only REASON why these members(which are signals) are PUBLIC B'se it is easy use use them.
  // OR we have write get/set functions for EACH members.
  // ADVANTAGE:The monitor/driver/checker code will be lot more readable if we could set/get them
  // by directly REFERING them.
  // E.g: memRasInterface.mem_ras_cid = memRasSideband.mem_ras_cid;
  // is lot more readable than memRasInterface.setMem_ras_cid(memRasSideband.getMem_ras_cid);.
  

  unsigned int   reset_l;
  unsigned int   clk;
  unsigned int   gsync;
  
  unsigned int   mem_ras_available;
  unsigned int   mem_ras_cell_length;
  unsigned int   mem_ras_cid;
  unsigned int   mem_ras_clp;
  unsigned int   mem_ras_data;
  unsigned int   mem_ras_efci;
  unsigned int   mem_ras_eof;
  unsigned int   mem_ras_eop;
  unsigned int   mem_ras_lfi_type;
  unsigned int   mem_ras_mlppp_length;
  unsigned int   mem_ras_param;
  unsigned int   mem_ras_portid;
  unsigned int   mem_ras_qid;
  unsigned int   mem_ras_sof;
  unsigned int   mem_ras_sop;
  unsigned int   mem_ras_tid;
  unsigned int   mem_ras_tidqid;
  unsigned int   mem_ras_type;

  unsigned int   ras_in_en;
  unsigned int   ras_out_en;

  unsigned int   ras_mem_ctrl_pop;
  unsigned int   ras_mem_data_pop;
 protected:
  
 private:
  memRasSidebandControlT(const sidebandControlT & rhs,const char * nameP = NULL);
  
   
};
#endif
