// ----------------------------------------------------------------------------
// (c) Copyright 2005, Springer.  All Rights Reserved. The code in this CD-ROM is
// distributed by Springer with ABSOLUTELY NO SUPPORT and NO WARRANTY from
// Springer. Use or reproduction of the information provided on this code for
// commercial gain is strictly prohibited. Explicit permission is given for the
// reproduction and use of this information in an instructional setting provided
// proper reference is given to the original source.  
// 
// Authors and Springer shall not be liable for damage in connection with, or
// arising out of, the furnishing, performance or use of the contents of the
// CD-ROM. 
// ----------------------------------------------------------------------------

#ifndef _REASSEMBLY_TESTCASE_H
#define _REASSEMBLY_TESTCASE_H

#include <iostream>
#include <fstream.h>
#include "driver/memRasDriver.h"
#include "monitor/memRasMonitor.h"
#include "generator/rasBlockDataGen.h"
#include "common/dataProvider.h"
#include "common/trafficScheduler.h"
#include "common/dataGram.h"
#include "common/cellDispatcher.h"
#include "common/monitorTask.h"
#include "common/controlData.h"
#include "common/messageHandler.h"
#include "sideband/memRasSidebandControl.h"
#include "common/interfaceDriverTask.h"
#include "checker/reassemblyChecker.h"
#include "common/cppunitVerif.h"

class reassemblyTestcaseSuiteT : public CppUnit::TestFixture {
public:
    virtual void setUp();
    virtual void tearDown();

    CPPUNIT_TEST_SUITE( reassemblyTestcaseSuiteT );  
    CPPUNIT_TEST( testMustPass );
    CPPUNIT_TEST_SUITE_END();
    
    void testMustPass();

    /// soon to be moved into baseclass
protected:
    trafficSchedulerTvmT *trafficSchedulerTvm;

    memRasDriverTvmT *memRasDriverTvm;
    memRasMonitorTvmT *inputMonitor;
    memRasMonitorTvmT *outputMonitor;
  
    reassemblyDataGenT * rasDataProvider;

    reassemblyCheckerT *rasChecker;

    cellDispatcherTaskT *rasMonitorDispatch;

    ofstream *checkerStream;
    ofstream *driverStream;
    ofstream *inputMonitorStream;
    ofstream *outputMonitorStream;
    ofstream *schedulerStream;
    
};


#endif
