(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L3, e8,  24, "New York"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  18, "New York"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  14, "New York"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L2, a20,  14, "New York"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L2, a15,  12, "New York"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L2, a12,  10, "New York"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  10, "New York"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L2,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L2,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L2,  12, "Courier"; 
	fontset = name, inactive, nowordwrap, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535, L2,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  10, "Times"; 
	fontset = leftheader, inactive, L2,  10, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "Times"; 
	fontset = leftfooter, inactive, center, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  10, "Geneva"; 
	fontset = clipboard, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = completions, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special1, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special2, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "New York"; 
	fontset = special3, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, right, M7, L2,  12, "New York"; 
	fontset = special4, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special5, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	paletteColors = 128; currentKernel; 
]
:[font = input; initialization; dontPreserveAspect; startGroup]
*)
BeginPackage["DKernel`","Global`"];
(*
:[font = input; initialization; dontPreserveAspect]
*)
Needs["Algebra`ReIm`"]
(*
:[font = input; preserveAspect]
(* Version dated February 28, 1992, Update 1/3/95 *)
:[font = input; initialization; dontPreserveAspect]
*)
RealRoot[root_,mult_,iVar_]:=
	NestList[#*iVar&,Exp[root*iVar],mult-1]
(*
:[font = input; initialization; dontPreserveAspect]
*)
CpxRoot[ComplexRoot_,mult_,iVar_]:=
	Block[{a=Re[ComplexRoot],b=Im[ComplexRoot]},
		NestList[#*iVar&,
		{Exp[a*iVar]Cos[b*iVar],
			Exp[a*iVar]Sin[b*iVar]},
		mult-1]
		]
(*
:[font = input; initialization; dontPreserveAspect]
*)
Attributes[times]={Flat};
times[{a_,m_},{a_,n_}]:=times[{a,m+n}]
RunEncode[x_List]:=List@@times@@({#,1}&/@x)
(*
:[font = input; initialization; wordwrap; dontPreserveAspect]
*)
DKernel::usage = "DKernel[eqn,y[x],x] finds a kernel for a single constant coefficients homogeneous linear differential equation eqn. The parameters have the same form as those of DSolve.";
(*
:[font = input; initialization; dontPreserveAspect]
*)
Clear[eqn,dVar,iVar,DKernel,u,p,r,w]
DKernel[eqn_,dVar_,iVar_?AtomQ]:=
	Module[{test,operator,charPoly,u,p,AllRoots,
			order,factors,basis,const,r,w,
			dVName=Head[dVar],theRealRoots,
			theCpxRoots},
		test=eqn/.{dVName[iVar]->0,
				Derivative[p_][dVName][iVar]->0};
		(*Print[test];*)
		If[!test,
		Return[
			StringForm["DKernel[``,``,``]",
			eqn,dVar,iVar]]];
		Clear[u,const,r,w];
		operator[iVar,w_]=(eqn[[1]]-eqn[[2]])/.
			dVName->w;
		(*Print[operator[iVar,dVName]];*)
		charPoly=Coefficient[
			operator[iVar,Exp[r*#]&],Exp[r*iVar]];
		(*Print[charPoly];*)
		AllRoots=r/.Solve[charPoly==0,r];
		(*Print[AllRoots];*)
		theRealRoots=
			RunEncode[Select[AllRoots,
				(Head[N[#]]==Real||
				 Head[N[#]]==Integer)&]];
		theCpxRoots=
			RunEncode[Select[AllRoots,
				(Head[N[#]]==Complex&&Im[N[#]]>0)&]];
		(*Print[{theRealRoots,theCpxRoots}];*)
		Join[Flatten[Map[Apply[RealRoot[#1,#2,iVar]&,#]&,
				theRealRoots]],
			Flatten[Map[Apply[CpxRoot[#1,#2,iVar]&,#]&,
				theCpxRoots]]]
		]
(*
:[font = input; initialization; dontPreserveAspect; endGroup]
*)
EndPackage[]
(*
^*)
