(*^

::[paletteColors = 128; currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L3, e8,  24, "New York"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "New York"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  14, "New York"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  14, "New York"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  12, "New York"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  10, "New York"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "New York"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; ;
	fontset = name, inactive, nowordwrap, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; ;
	fontset = Left Header, inactive,  10, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; ;
	fontset = Left Footer, inactive, center,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Geneva"; ;
	fontset = clipboard, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = completions, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special1, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special2, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, center, M7,  12, "New York"; ;
	fontset = special3, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, right, M7,  12, "New York"; ;
	fontset = special4, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special5, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;]
:[font = input; initialization; preserveAspect; ]
*)
BeginPackage["DSolveOrdinarySeries`"]
(*
:[font = input; initialization; wordwrap; preserveAspect; ]
*)
DSolveOrdinarySeries::usage = "DSolveOrdinarySeries[Leading,PMatrix,Initial,x,x0,NTerms] returns NTerms terms of the series solution of the first order differential system 
					(Leading)u'[x] = PMatrix.u[x]
in powers of (x-x0) having initial condition
					u[x0]= Initial.
Initial can be either a vector or a matrix."
(*
:[font = input; initialization; preserveAspect; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[MapSeries]
MapSeries[f_,{x_,x0_,n_}]:=If[TrueQ[Head[f]==List],
	Map[MapSeries[#,{x,x0,n}]&,f],Series[f,{x,x0,n}]]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[ExponentFromSeries]
ExponentFromSeries[SeriesInfo_]:=
	If[TrueQ[Head[SeriesInfo]==SeriesData],
		Length[SeriesInfo[[3]]]-1+SeriesInfo[[4]],
		0]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[CoefficientFromSeries]
CoefficientFromSeries[SeriesInfo_,k_]:=
	Block[{m,coeff},
		If[TrueQ[Head[SeriesInfo]==SeriesData],
			m=SeriesInfo[[4]];
			coeff=SeriesInfo[[3]];
			If[TrueQ[(k<m)||(k>m-1+Length[coeff])],
				0,
				coeff[[k+1-m]]
				],
			If[TrueQ[k==0],SeriesInfo,0]
		]
	]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[PrintSystemInfo]
PrintSystemInfo[Leading_,PMatrix_,Initial_,x0_]:=
	Block[{},
		Print["Given the linear differential system:"];
		Do[Print[StringForm["(``)*u[``]'[x] == ``.u[x]",
				Leading,i,PMatrix[[i]]]],
			{i,1,Length[Initial]}];
		Print["with initial condition:"];
		Do[Print[StringForm["    u[``][``] == ``,",
				i,x0,Initial[[i]]]],
			{i,1,Length[Initial]}];
		Print[StringForm["find a series solution about the ordinary point x == ``.",
			x0]];
		Print[];]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[PrintSolutionInfo]
PrintSolutionInfo[c_,P_,d_,x_,x0_,degree_,NTerms_]:=
	Block[{i,j,IM},
		IM=IdentityMatrix[Length[c[0]]];
		Print["The first few coefficients in the solution series:"];
		Print[StringForm["u[x] = Sum[c[i]*``,{i,0,``}],",(x-x0)^i,NTerms]];
		Print[];
		Print["are:"];
		Print[StringForm["c[``] = ``",0,c[0]]];
		Do[Print[StringForm["c[``] = (``.c[``]",
				i,P[0]-(i-1)*d[1]*IM,i-1]];
			Do[Print[StringForm["      + ``.c[``]",
					P[j]-(i-j-1)*d[j+1]*IM,i-j-1]],
				{j,1,i-1}];
			Print[StringForm["       )/``",i*d[0]]];
			Print["     = ",c[i]],
			{i,1,degree}];
		Print["and the coefficients propagate according to the rule"];
		Print[StringForm["c[k] = (``.c[k-1]",
				P[0]-(k-1)*d[1]*IM]];
		Do[Print[StringForm["      + ``.c[k-``]",
				P[j]-(k-j-1)*d[j+1]*IM,j+1]],
			{j,1,degree}];
		Print[StringForm["       )/(``)",k*d[0]]];
		Print[StringForm["for k >= ``.", degree+1]]
		]
(*
:[font = section; inactive; initialization; pageBreak; dontPreserveAspect; ]
DSolveOrdinarySeries
;[s]
2:0,1;20,0;21,-1;
2:1,19,14,New York,1,14,0,0,0;1,19,14,New York,1,14,65535,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
Clear[DSolveOrdinarySeries]
DSolveOrdinarySeries[Leading_,
					PMatrix_List,
					Initial_List,
					x_?AtomQ,
					x0_,
					NTerms_:10]:=
	Block[{IM,d,PSeries,t,degree,P,c,i,
			TraceOn=False},
		PrintSystemInfo[Leading,PMatrix,Initial,x0];
		IM=IdentityMatrix[Length[Initial]];
		LSeries[t_]=(Series[Leading,{x,x0,NTerms}])/.x->t;
		degreeL=ExponentFromSeries[LSeries[x]];
		If[TraceOn,Print["degreeL == ",degreeL]];
		Clear[d,P,c];
		d[0]=Normal[LSeries[x0]];
		Do[d[i]=CoefficientFromSeries[LSeries[x],i],
			{i,1,NTerms}];	
		PSeries[t_]=
			Map[Map[
				Series[#,{x,x0,NTerms+1}]&,#]&,
					PMatrix]/.x->t;
		If[TraceOn,Print["PSeries[x] == ",PSeries[x]]];
		degreeP=Min[Max[
			Flatten[Map[Map[ExponentFromSeries,#]&,
				PSeries[x]]]],
			NTerms];
		If[TraceOn,Print["degreeP == ",degreeP]];
		P[0]=PSeries[x0];
		If[TraceOn,Print["P[0] = ",P[0]]];
		Do[	P[i]=Map[Map[CoefficientFromSeries[#,i]&,#]&,
					PSeries[x]
					];
			If[TraceOn,Print[StringForm["P[``] == ``",i,P[i]]]],
			{i,1,NTerms}];
		c[0]=Initial;
		Do[c[i]:=
			c[i]=Sum[(P[j]-(i-j-1)*d[j+1]*IM).c[i-j-1],
					{j,0,Min[i-1]}]/(i*d[0]),
			{i,1,NTerms}];
		DSolveOrdinarySeriesData=
			{x,x0,
				Table[c[i],{i,0,Max[degreeP,degreeL-1]}],
				Reverse[Table[P[i]-(k-i-1)*d[i+1]*IM,
					{i,0,Max[degreeP,degreeL-1]}]]
			};
		PrintSolutionInfo[c,P,d,x,x0,
			Max[degreeP,degreeL-1],NTerms];
		MapSeries[Sum[c[i]*(x-x0)^i,{i,0,NTerms}],
				{x,x0,NTerms}]
		]
(*
:[font = input; initialization; preserveAspect; ]
*)
End[]
(*
:[font = input; initialization; preserveAspect; ]
*)
EndPackage[]
(*
^*)