(*^

::[paletteColors = 128; automaticGrouping; currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e8,  24, "Times"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L1, e6,  18, "Times"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, L1, e6,  14, "Times"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L1, a20,  18, "Times"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L1, a15,  14, "Times"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L1, a12,  12, "Times"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L1,  12, "Courier"; ;
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, L1,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = Left Header, inactive,  12, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7, L1,  12, "Times"; ;
	fontset = Left Footer, inactive,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  10, "Times"; ;
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L1,  12, "Times"; ;]
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
(* :Title To First Order System *)
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
BeginPackage["FirstOrderSystem`"]
(*
:[font = input; initialization; wordwrap; preserveAspect; groupLikeNormal; ]
*)
FirstOrderSystem::usage = "FirstOrderSystem[{eqns},{vars},t] converts a system of mixed order differential equations into a first order system of differential equations. The arguments of the function are the same as those of DSolve. The result returned can be solved by Apply[DSolve,%].A third order dependent variable x is converted into x[0],x[1],x[2]; similarly for other dependent variables."
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
(* Auxiliary functions *)
(*
:[font = input; initialization; dontPreserveAspect; groupLikeNormal; ]
*)
ToOrder[y_,t_]:={y[t]->0,
					Derivative[n_][y][t]->n,
					a_ Derivative[m_][y][t]->m}
(*
:[font = input; initialization; dontPreserveAspect; groupLikeNormal; ]
*)
NullSub[vars_List,t_]:=Block[{mat,i,
					zers=Table[0,{i,1,Length[vars]}]},
			mat=Transpose[{vars,zers,
							Map[
				Function[e2,Derivative[n_][Head[e2]][t]],vars],
							zers}];
			mat=Partition[Flatten[mat],2];
			(*Print[mat];*)
			Map[Function[e1,Apply[Rule,e1]],mat]
					]
(*
:[font = input; initialization; dontPreserveAspect; groupLikeNormal; ]
*)
RemoveOther[other_,de_]:=Block[{i,len=Length[de],mat},
			Array[mat,len]
			Do[mat[i]=
				If[TrueQ[other[[i]]],
				(* then *)
					de[[i,1]]-de[[i,2]],
				(* else *)
					de[[i,1]]-other[[i,1]]-
					(de[[i,2]]-other[[i,2]])
					],{i,1,len}];
			Table[mat[i],{i,1,len}]]
(*
:[font = input; initialization; dontPreserveAspect; groupLikeNormal; ]
*)
MaxOrder[deh_,vars_,t_]:=Block[{result,j},
	result=If[Length[vars]==0,
			(* then *)
				(deh/.Plus->List)/.
					ToOrder[Apply[Head,vars],t],
			(* else *)
			Table[(deh/.
				NullSub[Drop[vars,{j,j}],t]/.Plus->List)/.
				ToOrder[Head[Take[vars,{j,j}][[1]]],t],
			{j,1,Length[deh]}
			]];
	(*Print["***",result];*)
	Map[Max,Map[Flatten,result]]]
(*
:[font = input; initialization; dontPreserveAspect; groupLikeNormal; ]
*)
subs[VarMaxOrd_,vars_,j_,t_]:=Block[{nam=Head[Take[vars,{j,j}][[1]]]},
			Join[{nam[t]->nam[0][t]},
				Table[Derivative[i][nam][t]->nam[i][t],
					{i,1,VarMaxOrd[[j]]-1}],
				{(Derivative[VarMaxOrd[[j]]][nam][t])->
					(nam[VarMaxOrd[[j]]-1])'[t]}]]
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
(* Main Function *)
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
FirstOrderSystem[de_List,vars_List,t_]:=
		Block[{	other,deh,VarMaxOrd,CoeffMats,
				HighOrderCoeff,FcnNameHeads,FunctionSubs,
				HOV,deTrf,solns,NewDE,short},
			(*Print["NullSub: ",NullSub[vars,t]];*)
			other=de/.NullSub[vars,t];
			(*Print["other: ",other];*)
			deh=RemoveOther[other,de];
			(*Print["deh: ",deh];*)
			FcnNameHeads=Map[Head,vars];
			(*Print["FcnNameHeads: ",FcnNameHeads];*)
			VarMaxOrd=MaxOrder[deh,vars,t];(* deh? *)
			(*Print["VarMaxOrd: ",VarMaxOrd];*)
			CoeffMats=Table[Map[Function[e,Coefficient[deh,
				Derivative[i][Head[e]][t]]],vars],
					{i,0,Max[VarMaxOrd]}];
			(*Print["CoeffMats: ",CoeffMats];*)
			HighOrderCoeff=Table[
					CoeffMats[[VarMaxOrd[[i]]+1,i]],
					{i,1,Length[de]}];
			(*Print["HighOrderCoeff: ",HighOrderCoeff];*)
			HOV=Map[Function[e,Apply[Function[{e1,e2},
				(e1[e2-1])'[t]],e]],
				Transpose[{FcnNameHeads,VarMaxOrd}]];
			(*Print["HOV: ",HOV];*)
			If[Det[HighOrderCoeff]==0,
				Print["Degenerate System"];Return[]];
			FunctionSubs=Flatten[Table[
							subs[VarMaxOrd,vars,j,t],
							{j,1,Length[vars]}]];
			(*Print["FunctionSubs: ",FunctionSubs];*)
			deTrf=de/.FunctionSubs;
			(*Print["deTrf:",deTrf];*)
			{solns}=Solve[deTrf,HOV];
			NewDE=HOV/.solns;
			short=If[Length[deh]==1,
				{LogicalExpand[HOV==NewDE]},
				Apply[List,LogicalExpand[HOV==NewDE]]];
			(*Print["short",short];*)
			(* Now produce a DSolve-compatible output *)
			{Flatten[Table[(* First the D.E.s *)
					Join[
						Table[
							(FcnNameHeads[[j]][i])'[t]==
				 		 	FcnNameHeads[[j]][i+1][t],
							{i,0,VarMaxOrd[[j]]-2}
							],
						{short[[j]]}
						],
					{j,1,Length[vars]}]],
				Flatten[Table[(* Then the new Vars *)
							Table[
								FcnNameHeads[[j]][i][t],
								{i,0,VarMaxOrd[[j]]-1}
								],
						{j,1,Length[vars]}]],(* and t *)
				t}
			]
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
End[]
(*
:[font = input; initialization; preserveAspect; groupLikeNormal; ]
*)
EndPackage[]
(*
^*)