
(* Package Name: LPT4.m (works with version 4.0)

Since NewLPT.m, this package is totally new. No parts of the original LPT.m \
remain. The changes were necessitated by Mathematica v. 3.0, which deleted \
(or totally changed) the Calculus`Common` file that LPT.m relied on. NewLPT.m \
relied on Calculus`LaplaceTransform` rather than \
RossDE`BasicLaplaceTransform`, which LPT.m relied on.

The present version relies heavily on the extended treatment of Laplace \
transforms that are built into Mathematica 4.0, and on no other packages.

NewLPT.m, by Clay C. Ross, was dated March 28, 1998.

LPT4.m, the present version, is also by Clay C. Ross, and is dated March 8, \
2000.

 *)
BeginPackage["RossDE`LPT4`", "Global`"];
     
ClearAll[Transform, Isolate, LPTSolve, UnitPulse];

Transform::usage = "Transform[y[t],t,s] produces the Laplace transform Y[s]. \
\n\n 

Transform[{f1,f2, ...},t,s] \n produces a list of Laplace transforms of f1, \
f2, ... . If fj has the form of an initial condition y[0]==a, or y'[0]==b, \
etc, fj is passed through unchanged.\n\n  
Transform[sys,vars,t,s] \n applies the Laplace transform to each differential \
equation in the initial value problem sys. Transform has the form of DSolve \
with one extra parameter. vars is either the unknown function or a list of \
the unknown functions.";
 
Isolate::usage = "Isolate[TransformedSys,vars,t,s] solves TransformedSys for \
the LPT of each unknown function in vars. The result has the form \
{{LaplaceTransform[y1[t],t,s]->Y1[s],...}}. InverseLaplaceTransform[#,t,s] \
can be applied to the result."; 

LPTSolve::usage = "LPTSolve[sys,vars,t,s] applies Transform[sys,vars,t,s], \
Isolate[TransformedSys, vars,t,s], and InverseTransform[IsoVars,s,t] in order \
to solve sys by Laplace Transforms in one step. Intermediate results are \
normally displayed."; 

UnitPulse::usage = "UnitPulse[t,a,b] when a<b, is 0 if t<a or t>b and 1 when \
a<=t<=b; it evaluates to 1 if t>a or t<b and 0 when b<=t<=a."; 

Begin["`Private`"]; 
Off[General::spell1];

UnitPulse[t_, a_, b_] := 
   If[TrueQ[N[a] < N[b]], 
   UnitStep[t - a] - UnitStep[t - b], 
   (1-UnitStep[t -b] -UnitStep[t - a])] 

Clear[ToInitRules]; 
ToInitRules[Initsys_, TheVars_, t_,s_] := 
	Module[{FlatInitSys, VarNames = Head /@ Flatten[			{TheVars}], initSolve}, 
    FlatInitSys = Flatten[Initsys /. 
        {Equal -> List, Times -> List, Plus -> List}]; 
    initSolve = 
      Join[Flatten[(Select[FlatInitSys, 
            Function[u,!FreeQ[u, #1]]]&) /@ 					VarNames]]; 
     If[Initsys == {}, {}, First[Solve[Initsys, 			initSolve]]]
	]

Clear[ExtractInitConditions]; 
  ExtractInitConditions[sys_, t_, s_] := 
   Select[sys, Head[#1] == Equal && FreeQ[#1, t] & ] 

Transform[sys1_, t_Symbol, s_] := 
   Module[{sysList, InitCond, TrfSys, Result}, 
    sysList=If[TrueQ[Head[sys1]==List],sys1, {sys1}]; 
    InitCond = ExtractInitConditions[sysList, t, s]; 
    TrfSys = Select[sysList,!MemberQ[InitCond,#1]&]; 
    Result = 
      (Join[LaplaceTransform[TrfSys, t, s], 	
      	InitCond]); 
    If[Length[Result] > 1,Result,First[Result]]]

Transform[sys1_, TheVars_, t_Symbol, s_] := 
   Module[{sysList,InitCond,TrfSys,ICRules,Result}, 
   sysList=If[TrueQ[Head[sys1]==List], sys1, {sys1}]; 
   InitCond = ExtractInitConditions[sysList, t, s]; 
   TrfSys = Select[sysList,!MemberQ[InitCond, #1]& ]; 
   ICRules = ToInitRules[InitCond, TheVars, t, s]; 
   Result = LaplaceTransform[TrfSys, t, s] /.ICRules; 
   If[Length[Result] > 1, Result, First[Result]]]

Isolate[TrfSys_, vars_, t_, s_] := 
   Module[{Localvars, Trfvars}, 
    Localvars = 
      If[TrueQ[Head[vars] =!= List], {vars}, vars]; 
     Trfvars = 
      (LaplaceTransform[#1, t, s] & ) /@ Localvars; 
     Apart[First[Solve[TrfSys, Trfvars]]] ]

LPTSolve[sys_, vars_, t_, s_, Display_:True] := 
   Module[{TrfSys, IsoVars}, 
    TrfSys = 
     If[TrueQ[Head[sys] == List], 
       Transform[sys,vars,t,s],Transform[sys,t,s]]; 
     If[TrueQ[Display], 
      Print["The transformed system"]; Print[TrfSys]]; 
     IsoVars = Isolate[TrfSys, vars, t, s]; 
     If[TrueQ[Display], 
      	Print["The unknown(s) isolated."];Print[					IsoVars]]; 
     Simplify[InverseLaplaceTransform[IsoVars,s,t]]
     ]

On[General::spell1]; 
End[]; 
EndPackage[];
