(*^

::[paletteColors = 128; 
	fontset = title, "New York", 24, L3, center, bold, nohscroll;
	fontset = subtitle, "New York", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "New York", 14, L2, center, bold, nohscroll;
	fontset = section, "New York", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "New York", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "New York", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "New York", 12, L2, nohscroll;
	fontset = smalltext, "New York", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = input; initialization; ]
*)
BeginPackage["PlotIntegralCurves`"]
(*
:[font = text; inactive; ]
This package allows one to define a differential equation having the form:

The functions f[x, y] and g[x, y] are externally defined by the user.
 To generate (but not plot) a direction field for the differential equation, invoke  Field= MakeTangents[a,b,c,d,n] where {a,b} and {c,d} are opposite corners of the enclosing rectangle, and  n  is the number of subdivisions of {a,b} and {c,d}.  'Field' is merely a name for the object.
  To generate (but not plot) integral curves for the differential equation, invoke curves=MakeCurves[f,g,{startingPoints},h,n], where f, g are from the equation, {startingPoints} is a list of initial points from which to generate integral curves, h is the stepping increment for Euler's method, and  n  is the number of points to generate on the integral curve. Again, 'curves' is merely a name. (Make h<0 to reverse plot direction.)  Use Join to concatenate sets of curves produced in different manners.
 To actually plot the objects which you have constructed, do one of these two things:
-- If you have a color monitor and do not wish to produce printed copy,
invoke ColorVFSolution[a,b,c,d,Field,curves] for an on-screen color plot (which will not print well). 
(Invoke ColorVFSolution[a,b,c,d,Field,{}] to plot no integral curves or ColorVFSolution[a,b,c,d,{},curves] to plot no direction field.)
-- If you have a black & white monitor or wish to produce printed copy, invoke BWVFSolution[a,b,c,d,Field,curves]. 
(Invoke BWVFSolution[a,b,c,d,Field,{}] to plot no integral curves or BWVFSolution[a,b,c,d,{},curves] to plot no direction field.)
;[s]
32:0,0;148,3;192,0;232,1;262,0;437,3;479,0;518,1;561,0;874,1;878,0;941,3;997,0;1106,2;1143,0;1202,4;1210,5;1243,6;1244,4;1273,6;1274,5;1309,4;1337,0;1417,2;1454,4;1462,5;1492,6;1493,4;1522,6;1523,5;1555,4;1583,0;1584,-1;
7:10,17,12,New York,0,12,0,0,0;3,17,12,New York,1,12,0,0,0;2,14,10,Courier,1,12,0,0,0;3,17,12,New York,4,12,0,0,0;6,14,10,New York,0,10,0,0,0;4,13,9,Courier,1,10,0,0,0;4,13,9,Courier,0,10,0,0,0;
:[font = input; initialization; ]
*)
MakeTangents::usage = "MakeTangents[a,b,c,d,n] produces a table of line segments which represent slopes at an nXn lattice of points in [a, b]X[c, d]."
(*
:[font = input; initialization; ]
*)
MakeCurves::usage = "MakeCurves[f,g,startPoints_List,h,n] produces a collection of curves having step size and direction  h  consisting of n  Euler steps beginning at each point in startingPoints."
(*
:[font = input; initialization; ]
*)
ColorVFSolution::usage = "ColorVFSolution[a,b,c,d,Field,curves] plots in color the given Field and curves within the rectangle [a, b]X[c, d]."
(*
:[font = input; initialization; ]
*)
BWVFSolution::usage = "BWVFSolution[a,b,c,d,Field,curves] plots in Black & White the given Field and curves within the rectangle [a, b]X[c, d]."
(*
:[font = input; initialization; ]
*)
Clear[Dir]
Dir[f_,g_,x_,y_]:=Block[{len,dx,dy,slope},
	dx=g[x,y];
	dy=f[x,y];
	len=Sqrt[dx^2+dy^2];
	slope=If[TrueQ[len==0],{0,0},m{dx,dy}/len]]
(*
:[font = input; initialization; ]
*)
Clear[points]
points[a_,b_,c_,d_,n_]:=Block[{h=(b-a)/n,k=(d-c)/n,i,j},
	m=.01*Sqrt[(b-a)^2+(d-c)^2];
	Partition[Flatten[
		Table[{a+i*h,c+j*k},{i,1,n-1},{j,1,n-1}]]
		,2]
	]
(*
:[font = input; initialization; ]
*)
PointsToVectors[p_]:=
	Block[{vec=Apply[Dir[f,g,#1,#2]&,p]},
		N[{p-vec,p+vec}]
		]
(*
:[font = input; initialization; ]
*)
MakeTangents[a_,b_,c_,d_,n_]:=
	Map[Line,Map[PointsToVectors,points[a,b,c,d,n]]];
(*
:[font = input; initialization; ]
*)
MakeCurves[f_,g_,startPoints_List,h_,n_]:=
	Map[Line[NestList[EulerStep[#,f,g,h]&,#,n]]&,
		startPoints]
(*
:[font = input; initialization; ]
*)
Clear[ColorVFSolution]
ColorVFSolution[a_,b_,c_,d_,vList_,curves_]:=
	Show[
	Graphics[{RGBColor[0,1,1],vList}],
	Map[Graphics[{RGBColor[1,0,0],#}]&,curves],
	Background->RGBColor[0,0,2/10],
	PlotRange->{{a,b},{c,d}},
	Framed->True,
	AspectRatio->(d-c)/(b-a),
	DefaultColor->RGBColor[1,1,1],
	Axes->{0,0},
	Ticks->None]
(*
:[font = input; initialization; ]
*)
Clear[EulerStep]
EulerStep[p0_,f_,g_,h_]:=p0+h{Apply[g,p0],Apply[f,p0]}
(*
:[font = input; initialization; ]
*)
Clear[BWVFSolution]
BWVFSolution[a_,b_,c_,d_,vList_,curves_]:=
	Show[
	Graphics[vList],
	Graphics[curves],
	PlotRange->{{a,b},{c,d}},
	Framed->True,
	AspectRatio->(d-c)/(b-a),
	Axes->{0,0},
	Ticks->None]
(*
:[font = input; initialization; ]
*)
EndPackage[]
(*
^*)