(************** Content-type: application/mathematica **************
                     CreatedBy='%s'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7881,        260]*)
(*NotebookOutlinePosition[      8761,        292]*)
(*  CellTagsIndexPosition[      8717,        288]*)
(*WindowFrame->Normal*)



Notebook[{


Cell["BeginPackage[\"PlotIntegralCurves`\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell[TextData[{
  "This package allows one to define a differential equation having the form:\
\n\nThe functions f[x, y] and g[x, y] are externally defined by the user.\n\
\[Bullet] ",
  StyleBox["To generate (but not plot) a direction field",
    FontVariations->{"Underline"->True}],
  " for the differential equation, invoke  ",
  StyleBox["Field= MakeTangents[a,b,c,d,n]",
    FontWeight->"Bold"],
  " where {a,b} and {c,d} are opposite corners of the enclosing rectangle, \
and  n  is the number of subdivisions of {a,b} and {c,d}.  'Field' is merely \
a name for the object.\n\[Bullet]  ",
  StyleBox["To generate (but not plot) integral curves",
    FontVariations->{"Underline"->True}],
  " for the differential equation, invoke ",
  StyleBox["curves=MakeCurves[f,g,{startingPoints},h,n]",
    FontWeight->"Bold"],
  ", where f, g are from the equation, {startingPoints} is a list of initial \
points from which to generate integral curves, h is the stepping increment \
for Euler's method, and  n  is the number of points to generate on the \
integral curve. Again, 'curves' is merely a name. (Make h<0 to reverse plot \
direction.)  Use ",
  StyleBox["Join",
    FontWeight->"Bold"],
  " to concatenate sets of curves produced in different manners.\n\[Bullet]",
  StyleBox[" To actually plot the objects which you have constructed",
    FontVariations->{"Underline"->True}],
  ", do one of these two things:\n-- If you have a color monitor and do not \
wish to produce printed copy,\ninvoke ",
  StyleBox["ColorVFSolution[a,b,c,d,Field,curves]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " for an on-screen color plot (which will not print well). \n",
  StyleBox["(Invoke ",
    FontSize->10],
  StyleBox["ColorVFSolution[a,b,c,d,Field,{}]",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[" ",
    FontFamily->"Courier",
    FontSize->10],
  StyleBox["to plot no integral curves or",
    FontSize->10],
  StyleBox[" ",
    FontFamily->"Courier",
    FontSize->10],
  StyleBox["ColorVFSolution[a,b,c,d,{},curves] ",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox["to plot no direction field.)",
    FontSize->10],
  "\n-- If you have a black & white monitor or wish to produce printed copy, \
invoke ",
  StyleBox["BWVFSolution[a,b,c,d,Field,curves]. \n",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["(Invoke ",
    FontSize->10],
  StyleBox["BWVFSolution[a,b,c,d,Field,{}]",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[" ",
    FontFamily->"Courier",
    FontSize->10],
  StyleBox["to plot no integral curves or",
    FontSize->10],
  StyleBox[" ",
    FontFamily->"Courier",
    FontSize->10],
  StyleBox["BWVFSolution[a,b,c,d,{},curves] ",
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox["to plot no direction field.)",
    FontSize->10],
  ""
}], "Text",
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
MakeTangents::usage = \"MakeTangents[a,b,c,d,n] produces a table of \
line segments which represent slopes at an nXn lattice of points in [a, \
b]X[c, d].\"\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
MakeCurves::usage = \"MakeCurves[f,g,startPoints_List,h,n] produces \
a collection of curves having step size and direction  h  consisting of n  \
Euler steps beginning at each point in startingPoints.\"\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
ColorVFSolution::usage = \"ColorVFSolution[a,b,c,d,Field,curves] \
plots in color the given Field and curves within the rectangle [a, b]X[c, d].\
\"\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
BWVFSolution::usage = \"BWVFSolution[a,b,c,d,Field,curves] plots in \
Black & White the given Field and curves within the rectangle [a, b]X[c, \
d].\"\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Clear[Dir]
Dir[f_,g_,x_,y_]:=Block[{len,dx,dy,slope},
\tdx=g[x,y];
\tdy=f[x,y];
\tlen=Sqrt[dx^2+dy^2];
\tslope=If[TrueQ[len==0],{0,0},m{dx,dy}/len]]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Clear[points]
points[a_,b_,c_,d_,n_]:=Block[{h=(b-a)/n,k=(d-c)/n,i,j},
\tm=.01*Sqrt[(b-a)^2+(d-c)^2];
\tPartition[Flatten[
\t\tTable[{a+i*h,c+j*k},{i,1,n-1},{j,1,n-1}]]
\t\t,2]
\t]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
PointsToVectors[p_]:=
\tBlock[{vec=Apply[Dir[f,g,#1,#2]&,p]},
\t\tN[{p-vec,p+vec}]
\t\t]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
MakeTangents[a_,b_,c_,d_,n_]:=
\tMap[Line,Map[PointsToVectors,points[a,b,c,d,n]]];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
MakeCurves[f_,g_,startPoints_List,h_,n_]:=
\tMap[Line[NestList[EulerStep[#,f,g,h]&,#,n]]&,
\t\tstartPoints]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Clear[ColorVFSolution]
ColorVFSolution[a_,b_,c_,d_,vList_,curves_]:=
\tShow[
\tGraphics[{RGBColor[0,1,1],vList}],
\tMap[Graphics[{RGBColor[1,0,0],#}]&,curves],
\tBackground->RGBColor[0,0,2/10],
\tPlotRange->{{a,b},{c,d}},
\tFramed->True,
\tAspectRatio->(d-c)/(b-a),
\tDefaultColor->RGBColor[1,1,1],
\tAxes->{0,0},
\tTicks->None]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Clear[EulerStep]
EulerStep[p0_,f_,g_,h_]:=p0+h{Apply[g,p0],Apply[f,p0]}\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["\<\
Clear[BWVFSolution]
BWVFSolution[a_,b_,c_,d_,vList_,curves_]:=
\tShow[
\tGraphics[vList],
\tGraphics[curves],
\tPlotRange->{{a,b},{c,d}},
\tFramed->True,
\tAspectRatio->(d-c)/(b-a),
\tAxes->{0,0},
\tTicks->None]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}],

Cell["EndPackage[]", "Input",
  InitializationCell->True,
  ImageRegion->{{-0, 1}, {0, 1}}]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 624},
WindowMargins->{{20, Automatic}, {Automatic, 44}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1743, 53, 116, 2, 70, "Input",
  InitializationCell->True],
Cell[1862, 57, 2970, 80, 70, "Text"],
Cell[4835, 139, 243, 6, 70, "Input",
  InitializationCell->True],
Cell[5081, 147, 290, 6, 70, "Input",
  InitializationCell->True],
Cell[5374, 155, 235, 6, 70, "Input",
  InitializationCell->True],
Cell[5612, 163, 237, 6, 70, "Input",
  InitializationCell->True],
Cell[5852, 171, 235, 9, 70, "Input",
  InitializationCell->True],
Cell[6090, 182, 267, 10, 70, "Input",
  InitializationCell->True],
Cell[6360, 194, 175, 7, 70, "Input",
  InitializationCell->True],
Cell[6538, 203, 169, 5, 70, "Input",
  InitializationCell->True],
Cell[6710, 210, 194, 6, 70, "Input",
  InitializationCell->True],
Cell[6907, 218, 415, 15, 70, "Input",
  InitializationCell->True],
Cell[7325, 235, 158, 5, 70, "Input",
  InitializationCell->True],
Cell[7486, 242, 298, 13, 70, "Input",
  InitializationCell->True],
Cell[7787, 257, 91, 2, 70, "Input",
  InitializationCell->True]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)
