(*^

::[paletteColors = 128; 
	fontset = title, "New York", 24, L3, center, bold, nohscroll;
	fontset = subtitle, "New York", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "New York", 14, L2, center, bold, nohscroll;
	fontset = section, "New York", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "New York", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "New York", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "New York", 12, L2, nohscroll;
	fontset = smalltext, "New York", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = section; inactive; ]
Manipulate Series
:[font = input; initialization; ]
*)
Clear[MapSeries]
MapSeries[f_,{x_,x0_,n_}]:=If[TrueQ[Head[f]==List],
	Map[MapSeries[#,{x,x0,n}]&,f],Series[f,{x,x0,n}]]
(*
:[font = input; initialization; ]
*)
Clear[ExponentFromSeries]
ExponentFromSeries[SeriesInfo_]:=
	If[TrueQ[Head[SeriesInfo]==SeriesData],
		Length[SeriesInfo[[3]]]-1+SeriesInfo[[4]],
		0]
(*
:[font = input; initialization; ]
*)
Clear[CoefficientFromSeries]
CoefficientFromSeries[SeriesInfo_,k_]:=
	Block[{m,coeff},
		If[TrueQ[Head[SeriesInfo]==SeriesData],
			m=SeriesInfo[[4]];
			coeff=SeriesInfo[[3]];
			If[TrueQ[(k<m)||(k>m-1+Length[coeff])],
				0,
				coeff[[k+1-m]]
				],
			If[TrueQ[k==0],SeriesInfo,0]
		]
	]
(*
:[font = section; inactive; ]
PrintSystemInfo
:[font = input; initialization; ]
*)
Clear[PrintSystemInfo]
PrintSystemInfo[Leading_,PMatrix_,Initial_,x0_]:=
	Block[{},
		Print["Given the linear differential system:"];
		Do[Print[StringForm["(``)*u[``]'[x] == ``.u[x]",
				Leading,i,PMatrix[[i]]]],
			{i,1,Length[Initial]}];
		Print["with initial condition:"];
		Do[Print[StringForm["    u[``][``] == ``,",
				i,x0,Initial[[i]]]],
			{i,1,Length[Initial]}];
		Print[StringForm["find a series solution about the ordinary point x == ``.",
			x0]];
		Print[];]
(*
:[font = section; inactive; ]
PrintSolutionInfo
:[font = input; initialization; ]
*)
Clear[PrintSolutionInfo]
PrintSolutionInfo[c_,P_,d_,x_,x0_,degree_,NTerms_]:=
	Block[{i,j,IM},
		IM=IdentityMatrix[Length[c[0]]];
		Print["The first few coefficients in the solution series:"];
		Print[StringForm["u[x] = Sum[c[i]*``,{i,0,``}],",(x-x0)^i,NTerms]];
		Print[];
		Print["are:"];
		Print[StringForm["c[``] = ``",0,c[0]]];
		Do[Print[StringForm["c[``] = (``.c[``]",
				i,P[0]-(i-1)*d[1]*IM,i-1]];
			Do[Print[StringForm["      + ``.c[``]",
					P[j]-(i-j-1)*d[j+1]*IM,i-j-1]],
				{j,1,i-1}];
			Print[StringForm["       )/``",i*d[0]]];
			Print["     = ",c[i]],
			{i,1,degree}];
		Print["and the coefficients propagate according to the rule"];
		Print[StringForm["c[k] = (``.c[k-1]",
				P[0]-(k-1)*d[1]*IM]];
		Do[Print[StringForm["      + ``.c[k-``]",
				P[j]-(k-j-1)*d[j+1]*IM,j+1]],
			{j,1,degree}];
		Print[StringForm["       )/(``)",k*d[0]]];
		Print[StringForm["for k >= ``.", degree+1]]
		]
(*
:[font = section; inactive; pageBreak; ]
DSolveOrdinarySeries
;[s]
2:0,1;20,0;21,-1;
2:1,19,14,New York,1,14,0,0,0;1,19,14,New York,1,14,65535,0,0;
:[font = input; initialization; ]
*)
Clear[DSolveOrdinarySeries]
DSolveOrdinarySeries[Leading_,
					PMatrix_List,
					Initial_List,
					x_?AtomQ,
					x0_,
					NTerms_:10]:=
	Block[{IM,d,PSeries,t,degree,P,c,i,
			TraceOn=True},
		PrintSystemInfo[Leading,PMatrix,Initial,x0];
		IM=IdentityMatrix[Length[Initial]];
		LSeries[t_]=(Series[Leading,{x,x0,NTerms}])/.x->t;
		degreeL=ExponentFromSeries[LSeries[x]];
		Print["degreeL == ",degreeL]/;!TraceOn;
		Clear[d,P,c];
		d[0]=Normal[LSeries[x0]];
		Do[d[i]=CoefficientFromSeries[LSeries[x],i],
			{i,1,NTerms}];	
		PSeries[t_]=
			Map[Map[
				Series[#,{x,x0,NTerms+1}]&,#]&,
					PMatrix]/.x->t;
		Print["PSeries[x] == ",PSeries[x]]/;!TraceOn;
		degreeP=Min[Max[
			Flatten[Map[Map[ExponentFromSeries,#]&,
				PSeries[x]]]],
			NTerms];
		Print["degreeP == ",degreeP]/;!TraceOn;
		P[0]=PSeries[x0];
		Print["P[0] = ",P[0]]/;!TraceOn;
		Do[	P[i]=Map[Map[CoefficientFromSeries[#,i]&,#]&,
					PSeries[x]
					];
			Print[StringForm["P[``] == ``",i,P[i]]]/;!TraceOn,
			{i,1,NTerms}];
		c[0]=Initial;
		Do[c[i]:=
			c[i]=Sum[(P[j]-(i-j-1)*d[j+1]*IM).c[i-j-1],
					{j,0,Min[i-1]}]/(i*d[0]),
			{i,1,NTerms}];
		DSolveOrdinarySeriesData=
			{x,x0,
				Table[c[i],{i,0,Max[degreeP,degreeL-1]}],
				Reverse[Table[P[i]-(k-i-1)*d[i+1]*IM,
					{i,0,Max[degreeP,degreeL-1]}]]
			};
		PrintSolutionInfo[c,P,d,x,x0,
			Max[degreeP,degreeL-1],NTerms];
		MapSeries[Sum[c[i]*(x-x0)^i,{i,0,NTerms}],
				{x,x0,NTerms}]
		]
(*
:[font = section; inactive; ]
Example: First solution
:[font = input; startGroup; ]
w[x_]=DSolveOrdinarySeries[2(1+x^2),2{{0,1+x^2},{1,-x}},
	{1,0},x,0,6]
:[font = print; inactive; ]
Given the linear differential system:
        2                          2
2 (1 + x )*u[1]'[x] == {0, 2 (1 + x )}.u[x]
        2
2 (1 + x )*u[2]'[x] == {2, -2 x}.u[x]
with initial condition:
    u[1][0] == 1,
    u[2][0] == 0,
find a series solution about the ordinary point x == 0.

The first few coefficients in the solution series:
                 i
u[x] = Sum[c[i]*x ,{i,0,6}],

are:
c[0] = {1, 0}
c[1] = ({{0, 2}, {2, 0}}.c[0]
       )/2
     = {0, 1}
c[2] = ({{0, 2}, {2, 0}}.c[1]
      + {{0, 0}, {0, -2}}.c[0]
       )/4
        1
     = {-, 0}
        2
and the coefficients propagate according to the rule
c[k] = ({{0, 2}, {2, 0}}.c[k-1]
      + {{0, 0}, {0, -2}}.c[k-2]
      + {{0, 2}, {0, 0}}.c[k-3]
       )/(2 k)
for k >= 3.
:[font = output; inactive; output; endGroup; ]
{SeriesData[x, 0, {1, 0, 1/2, 0, -1/8, 0, 1/16}, 0, 7, 1], 
  SeriesData[x, 0, {1, 0, -1/2, 0, 3/8}, 1, 7, 1]}
;[o]
      2    4    6               3      5
     x    x    x        7      x    3 x        7
{1 + -- - -- + -- + O[x] , x - -- + ---- + O[x] }
     2    8    16              2     8
:[font = subsection; inactive; ]
Check
:[font = input; startGroup; ]
Simplify[(1+x^2)*w'[x]-{{0,1+x^2},{1,-x}}.w[x]]
:[font = output; inactive; output; endGroup; ]
{SeriesData[x, 0, {}, 6, 6, 1], SeriesData[x, 0, {}, 6, 6, 1]}
;[o]
     6      6
{O[x] , O[x] }
:[font = section; inactive; ]
Example: Second solution
:[font = input; startGroup; ]
w[x_]=DSolveOrdinarySeries[2(1+x^2),2{{0,1+x^2},{1,-x}},
	{0,1},x,0,6]
:[font = print; inactive; ]
Given the linear differential system:
        2                          2
2 (1 + x )*u[1]'[x] == {0, 2 (1 + x )}.u[x]
        2
2 (1 + x )*u[2]'[x] == {2, -2 x}.u[x]
with initial condition:
    u[1][0] == 0,
    u[2][0] == 1,
find a series solution about the ordinary point x == 0.

The first few coefficients in the solution series:
                 i
u[x] = Sum[c[i]*x ,{i,0,6}],

are:
c[0] = {0, 1}
c[1] = ({{0, 2}, {2, 0}}.c[0]
       )/2
     = {1, 0}
c[2] = ({{0, 2}, {2, 0}}.c[1]
      + {{0, 0}, {0, -2}}.c[0]
       )/4
     = {0, 0}
and the coefficients propagate according to the rule
c[k] = ({{0, 2}, {2, 0}}.c[k-1]
      + {{0, 0}, {0, -2}}.c[k-2]
      + {{0, 2}, {0, 0}}.c[k-3]
       )/(2 k)
for k >= 3.
:[font = output; inactive; output; endGroup; ]
{SeriesData[x, 0, {1}, 1, 7, 1], 1}
;[o]
         7
{x + O[x] , 1}
:[font = subsection; inactive; ]
Check
:[font = input; startGroup; ]
Simplify[(1+x^2)*w'[x]-{{0,1+x^2},{1,-x}}.w[x]]
:[font = output; inactive; output; endGroup; ]
{SeriesData[x, 0, {}, 6, 6, 1], SeriesData[x, 0, {}, 7, 7, 1]}
;[o]
     6      7
{O[x] , O[x] }
^*)