(*^

::[paletteColors = 128; currentKernel; 
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L3, e8,  24, "New York"; ;
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "New York"; ;
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  14, "New York"; ;
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  14, "New York"; ;
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  12, "New York"; ;
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  10, "New York"; ;
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "New York"; ;
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold,  12, "Courier"; ;
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535,  12, "Courier"; ;
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, "Courier"; ;
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; ;
	fontset = name, inactive, nowordwrap, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535,  10, "Geneva"; ;
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; ;
	fontset = Left Header, inactive,  10, "Times"; ;
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; ;
	fontset = Left Footer, inactive, center,  12, "Times"; ;
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Geneva"; ;
	fontset = clipboard, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = completions, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special1, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special2, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, center, M7,  12, "New York"; ;
	fontset = special3, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, right, M7,  12, "New York"; ;
	fontset = special4, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;
	fontset = special5, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7,  12, "New York"; ;]
:[font = input; initialization; dontPreserveAspect; ]
*)
(*  Error Messages  *)
Eqn::notHomog = "`` is not Homogeneous.";
Eqn::notExact = "`` is not Exact.";
Eqn::notSep = "`` is not Separable.";
Eqn::form = "`` contains extraneous terms.";
(*
;[s]
9:0,0;40,1;64,0;82,1;101,0;116,1;139,0;152,1;183,0;184,-1;
2:5,14,10,Courier,1,12,0,0,0;4,14,10,Courier,1,12,65535,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
(*  Information Messages  *)
SolveExactDE::usage = "SolveExactDE[de,x,y,Mu:1,ShowSteps->False] Mu is optional.";
SolveHomogeneousDE::usage = "SolveHomogeneousDE[de,x,y,ShowSteps->False]";
SolveSeparableDE::usage = "SolveSeparableDE[de,x,y,ShowSteps->False]";
CheckSoln::usage = "CheckSoln[de,soln,x,y]";
(*
;[s]
17:0,0;29,1;41,0;52,1;64,0;113,1;131,0;142,1;160,0;188,1;204,0;215,1;231,0;259,1;268,0;279,1;288,0;304,-1;
2:9,14,10,Courier,1,12,0,0,0;8,14,10,Courier,1,12,0,0,65535;
:[font = input; initialization; dontPreserveAspect; ]
*)
LogSub:=Log[e_]->Log[Abs[e]]
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
svar[v1_]:=ToExpression[StringJoin["d",ToString[v1]]];
dvar[v1_,a_,v2_,b_]:={svar[v1]->a,svar[v2]->b};
TestDEForm[de_,x_,y_]:=TrueQ[de/.dvar[x,0,y,0]];

(*
:[font = input; initialization; dontPreserveAspect; ]
*)
(* Set Options so that the internal workings of the 
	solution functions may be displayed.  Default: do not
	display internal workings *)
Options[SolveExactDE]:={ShowSteps->False};
Options[SolveHomogeneousDE]:={ShowSteps->False};
Options[SolveSeparableDE]:={ShowSteps->False};
(*
;[s]
3:0,0;101,1;107,0;277,-1;
2:2,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,65535,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
Default[SolveExactDE,4]:=1;
(*
:[font = input; initialization; dontPreserveAspect; ]
*)
SolveExactDE[de_,x_,y_,Mu_:1,opts___]:=
		Block[{eqn,m,n,dm,dn,res,im,phi,sub,
							ShowSteps},
		Clear[const,ShowSteps];
		ShowSteps=ShowSteps/.{opts}/.Options[SolveExactDE];
		If[!TestDEForm[de,x,y],Message[Eqn::form,de];Return[{}]];
		eqn=de[[1]]-de[[2]];
		If[ShowSteps,Print["The DE: ",eqn==0]];
		m=Mu*(eqn/.dvar[x,1,y,0]);			(*  This is M(x,y)  *)
		n=Mu*(eqn/.dvar[x,0,y,1]);			(*  This is N(x,y)  *)
		If[ShowSteps,Print[StringForm["M(``,``): ``",x,y,m]]];
		If[ShowSteps,Print[StringForm["N(``,``): ``",x,y,n]]];
		dm=D[m,y];
		dn=D[n,x];
		If[ShowSteps,Print[StringForm["D[M(`1`,`2`),`2`]: `3`",x,y,dm]]];
		If[ShowSteps,Print[StringForm["D[N(`1`,`2`),`1`]: `3`",x,y,dn]]];
		res=Simplify[dm-dn];		(*If res!=0, de is NOT Exact!! *)
		If[!SameQ[res,0],
			(* then *)
					Message[Eqn::notExact,de];
					Return[{}],
			(* else *)
					If[ShowSteps,Print[eqn," == 0 is Exact."]];
					im=Integrate[m,x]+ phi[y];
					If[ShowSteps,Print["f = ",im]];
					in=Integrate[D[im,y]-n,y];
					If[ShowSteps,Print[in," == 0 "]];
					{sub}=Solve[in==0,phi[y]];
					If[ShowSteps,Print["Solution is:"]];
					Return[((im/.sub)/.LogSub)==const]
					]
			]

(*
;[s]
29:0,2;12,0;86,6;95,0;124,6;178,0;261,6;303,0;333,1;334,0;338,4;352,0;392,4;406,0;411,6;525,0;551,6;687,5;689,0;713,3;741,0;847,6;890,0;928,6;959,0;997,6;1030,0;1068,6;1104,0;1158,-1;
7:14,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,65535,0;1,14,10,Courier,1,12,0,0,65535;1,14,10,Courier,1,12,65535,0,0;2,14,10,Courier,1,12,21844,21844,21844;1,14,10,Courier,1,12,43689,43689,43689;9,13,9,Courier,0,10,0,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
Attributes[Separate]={HoldAll}
Attributes[const]={Constant}

Separate[prod_,x_,y_]:=
		Block[{sep1,sep2},
			sep1=Exp[Integrate[
				Cancel[D[prod,x]/prod],
							x]
					];
			sep2=Cancel[prod/sep1];
			{sep1,sep2}]
			
Attributes[SolveSeparableDE]={HoldAll}

SolveSeparableDE[de_,x_,y_,opts___]:=
		Block[{eqn,m,n,m1,m2,n1,n2,ShowSteps},
			Clear[const];
			ShowSteps=ShowSteps/.{opts}/.Options[SolveSeparableDE];
			If[!TestDEForm[de,x,y],Message[Eqn::form,de];Return[{}]];
			eqn=de[[1]]-de[[2]];
			If[ShowSteps,Print["The DE: ",eqn == 0]];
			m=eqn/.dvar[x,1,y,0];
			n=eqn/.dvar[x,0,y,1];
			If[ShowSteps,Print[StringForm["M(``,``): ``",x,y,m]]];
				If[ShowSteps,Print[StringForm["N(``,``): ``",x,y,n]]];
			{m1,m2}=Separate[m,x,y];
			{n1,n2}=Separate[n,x,y];
			If[ShowSteps,Print[StringForm["M(``,``) separates into ``",x,y,{m1,m2}]]];
				If[ShowSteps,Print[StringForm["N(``,``) separates into ``",x,y,{n1,n2}]]];
			If[FreeQ[m1,y]&&FreeQ[m2,x]&&FreeQ[n1,y]&&FreeQ[n2,x],
					(* then *)
			If[ShowSteps,Print[StringForm[
						"Integrate[``,``]+Integrate[``,``] == const",(m1/n1),x,(n2/m2),y]]];
			((Integrate[m1/n1,x]+Integrate[n2/m2,y])/.LogSub)==const,
					(* else *)
			Message[Eqn::notSep,de];
			{}]
			]
(*
;[s]
13:0,0;262,1;278,0;361,2;416,0;505,2;546,0;600,2;713,0;773,2;926,0;1004,2;1109,0;1227,-1;
3:7,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,0,65535;5,13,9,Courier,0,10,0,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
Htest[t_,x_,y_,f_]:=Cancel[Collect[
						Map[Factor,(f/.{x->t*x,y->t*y})/f],
								t]]
								
OrderOfHomogeneity[expr_,t_]:=Exponent[expr,t]

SolveHomogeneousDE[de_,x_,y_,opts___]:=
	Block[{eqn,tForm,vForm,const,
								m1,n1,my,ny,mx,nx,ckm,ckn,soln,
								IsHom,deSubst1,deSubst2,ShowSteps},
	Off[Remove::local];
	Clear[const];
	Remove["t*","v*"];
	ShowSteps=ShowSteps/.{opts}/.Options[SolveHomogeneousDE];
	If[!TestDEForm[de,x,y],Message[Eqn::form,de];Return[{}]];
	eqn=de[[1]]-de[[2]];
	If[ShowSteps,Print["The DE: ",eqn == 0]];
	m1=eqn/.dvar[x,1,y,0];(* This is M(x,y) *)
	n1=eqn/.dvar[x,0,y,1];(* This is N(x,y) *)
	If[ShowSteps,Print[StringForm["M(``,``): ``",x,y,m1]]];
	If[ShowSteps,Print[StringForm["N(``,``): ``",x,y,n1]]];
	tForm=Unique["t"];
	vForm=Unique["v"];
	ckm=Htest[tForm,x,y,m1];
	ckn=Htest[tForm,x,y,n1];
	If[ShowSteps,Print[StringForm["M(`1` `2`,`1` `3`): `4`",tForm,x,y,ckm]]];
	If[ShowSteps,Print[StringForm["N(`1` `2`,`1` `3`): `4`",tForm,x,y,ckn]]];
	IsHom=If[FreeQ[ckm,x] && FreeQ[ckm,y] && 
			 FreeQ[ckn,x] && FreeQ[ckn,y],
			SameQ[OrderOfHomogeneity[ckm,tForm],
				  OrderOfHomogeneity[ckn,tForm]]];
	If[ShowSteps&&IsHom,Print[
						StringForm["Degree of Homogeneity: ``",OrderOfHomogeneity[ckn,tForm]]]];
	If[!IsHom,
		(* then *)
			Message[Eqn::notHomog,de];
			Return[{}],
		(* else*)
			deSubst1=eqn/.(svar[y]->
						(vForm svar[x] + x svar[vForm]))/.y->x vForm;
					my=Factor[Map[Factor,deSubst1/.
								dvar[x,1,vForm,0]]];
					ny=Factor[Map[Factor,deSubst1/.
								dvar[x,0,vForm,1]]];
			
			deSubst2=eqn/.(svar[x]->
						(vForm svar[y] + y svar[vForm]))/.x->y vForm;
					mx=Factor[Map[Factor,deSubst2/.
								dvar[y,1,vForm,0]]];
					nx=Factor[Map[Factor,deSubst2/.
								dvar[y,0,vForm,1]]]];
								
	(* Return with both substitutions made *)
	soln={	If[ShowSteps,Print[StringForm["Solve with `2` = `1` * `3`",vForm,y,x]]];
		(SolveSeparableDE[(my svar[x] + ny svar[vForm])==0,
					x,vForm,Options[SolveSeparableDE]]/.vForm->y/x),
			If[ShowSteps,Print[StringForm["Solve with `2` = `1` * `3`",vForm,x,y]]];
	(SolveSeparableDE[(mx svar[y] +  nx svar[vForm])==0,
					y,vForm,Options[SolveSeparableDE]]/.vForm->x/y)};
					If[ShowSteps,Print["The solution-pair is:"]];
					soln]
	
(*
;[s]
29:0,0;147,1;165,0;290,2;299,0;307,4;322,0;359,2;416,0;499,2;540,0;630,2;742,0;836,2;984,0;1142,2;1247,0;1772,3;1807,0;1819,2;1891,0;1959,2;1984,0;2003,2;2077,0;2143,2;2168,0;2190,2;2235,0;2249,-1;
5:15,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,0,65535;11,13,9,Courier,0,10,0,0,0;1,14,10,Courier,1,12,21844,21844,21844;1,14,10,Courier,0,12,65535,0,0;
:[font = input; initialization; dontPreserveAspect; ]
*)
CheckSoln[de_,soln_,x_,y_]:=Block[{total,sub,result},
			total=Dt[(soln/.Log[Abs[e_]]->Log[e]),t];
			{sub}=Solve[total,
															Dt[y,t]]/.{Dt[y,t]->svar[y],
																			Dt[x,t]->svar[x]};
			result=SameQ[Simplify[de/.sub],0];
			(* Return True if solution, else return discrepancy *)
			If[result,result,Simplify[de/.sub]]]
(*
;[s]
4:0,1;9,0;247,2;295,0;339,-1;
3:2,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,0,65535;1,14,10,Courier,1,12,21844,21844,21844;
^*)