(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L3, e8,  24, "New York"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  18, "New York"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  14, "New York"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L2, a20,  14, "New York"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L2, a15,  12, "New York"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L2, a12,  10, "New York"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  10, "New York"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L2,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L2,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L2,  12, "Courier"; 
	fontset = name, inactive, nowordwrap, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535, L2,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  10, "Times"; 
	fontset = leftheader, inactive, L2,  10, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "Times"; 
	fontset = leftfooter, inactive, center, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, L2,  10, "Geneva"; 
	fontset = clipboard, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = completions, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special1, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special2, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "New York"; 
	fontset = special3, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, right, M7, L2,  12, "New York"; 
	fontset = special4, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special5, inactive, nowordwrap, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	paletteColors = 128; currentKernel; 
]
:[font = input; preserveAspect]
(* Version 1.0. Modified 1/2/95 CCRoss *)
:[font = input; initialization; dontPreserveAspect]
*)
BeginPackage["VarPar`","Global`"]
(*
:[font = input; initialization; wordwrap; dontPreserveAspect]
*)
VarPar::usage = "VarPar[BasisOfKernel,RightHandSide, var] uses a basis of the kernel of the linear differential operator and the adjusted right hand side to produce a particular solution. The variable used is var.";
(*
:[font = input; initialization; dontPreserveAspect]
*)
Clear[VarPar]
VarPar[Ker_,fcn_,x_]:=
	Module[{	i,
			w=Table[D[Ker,{x,i}],{i,0,Length[Ker]-1}],
			rhs=Join[Table[0,{i,1,Length[Ker]-1}],{fcn}]
			},
		Simplify[Ker.Integrate[Simplify[Inverse[w].rhs],x]]
	]
(*
:[font = input; initialization; dontPreserveAspect]
*)
EndPackage[]
(*
^*)
