(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L3, e8,  24, "New York"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  18, "New York"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, L2, e6,  14, "New York"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, L2, a20,  14, "New York"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, L2, a15,  12, "New York"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, L2, a12,  10, "New York"; 
	fontset = text, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = smalltext, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  10, "New York"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L2,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L2,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L2,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287, L2,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic, B65535, L2,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  10, "New York"; 
	fontset = leftheader, inactive, L2,  10, "New York"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "New York"; 
	fontset = leftfooter, inactive, center, L2,  12, "New York"; 
	fontset = help, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  10, "Geneva"; 
	fontset = clipboard, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = completions, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special1, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special2, inactive, noKeepOnOnePage, preserveAspect, center, M7, L2,  12, "New York"; 
	fontset = special3, inactive, noKeepOnOnePage, preserveAspect, right, M7, L2,  12, "New York"; 
	fontset = special4, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	fontset = special5, inactive, noKeepOnOnePage, preserveAspect, M7, L2,  12, "New York"; 
	paletteColors = 128; currentKernel; 
]
:[font = input; initialization; dontPreserveAspect]
*)
(* This Package contains routines used for the solution
	of second order ordinary differential equations about
	either ordinary or regular singular points. The
	differential operator must have its coefficients 
	defined as {p[2],p[1],p[0]}, where the index indicates
	the order of the associated derivative. *)
(*
:[font = input; dontPreserveAspect]

(* Definition Section *)

;[s]
3:0,0;1,1;25,0;27,-1;
2:2,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,0,65535;
:[font = input; initialization; dontPreserveAspect]
*)
loadIntegral::usage = "loadIntegral"
(*
:[font = input; initialization; dontPreserveAspect]
*)
unNormal::usage = "unNormal[expr]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
aboutX0::usage = "aboutX0[x0,decoeff,n,z]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
minExponent::usage = "minExponent[poly]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
allPowers::usage = "allPowers"
(*
:[font = input; initialization; dontPreserveAspect]
*)
expandCompletely::usage = "expandCompletely[expr,unit]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
ordinarySeries::usage = "ordinarySeries[x0,numTerms]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
classify::usage = "classify[x0]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
varPar::usage = "varPar[basisOfKernel,f,leading]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
getIndices::usage = "getIndices[x]"
(*
:[font = input; initialization; dontPreserveAspect]
*)
regSingSeries::usage = "regSingSeries[r,x0,numTerms]"
(*
:[font = input; dontPreserveAspect]

(* Implementation Section *)

;[s]
3:0,0;1,1;30,0;31,-1;
2:2,14,10,Courier,1,12,0,0,0;1,14,10,Courier,1,12,0,0,65535;
:[font = input; initialization; dontPreserveAspect]
*)
seriesSolveLoaded=True;
(*
:[font = input; initialization; dontPreserveAspect]
*)
unNormal[expr_]:=If[SameQ[expr[[0]],Normal],expr[[1]],expr]
(*
:[font = input; initialization; dontPreserveAspect]
*)
aboutX0[x0_,decoeff_,n_,z_]:= Block[{i,j},
		Table[Sum[
			(D[decoeff[[i]],{x,j}]/Factorial[j]*z^j/.x->x0),
				{j,0,n-1}],{i,1,3}]]
(*
:[font = input; initialization; dontPreserveAspect]
*)
minExponent[poly_]:=Block[{z,m1},
			m1=Exponent[poly,xmx0];
			If[NumberQ[m1],
				Return[m1-Exponent[
					Expand[(poly/.xmx0->1/z)*z^m1],z]],
				Return[0] ]]
(*
:[font = input; initialization; dontPreserveAspect]
*)
allPowers:=Block[{mins,i,tab},
			(*Print[{p[2],p[1],p[0]}];*)
			{mins[2],mins[1],mins[0]}
					=Map[minExponent,{p[2],p[1],p[0]}];
			Do[(mins[i]=mins[i]-i)/;NumberQ[mins[i]],
					{i,0,2}];
			tab=Table[Exponent[p[i],xmx0]-i,{i,0,2}];
			(*Print[tab];*)
			Select[Union[{mins[2],mins[1],mins[0]},
						tab],NumberQ] ]
(*
:[font = input; initialization; dontPreserveAspect]
*)
expandCompletely[expr_,unit_]:=
		Block[{z,temp},
			temp=Expand[expr/.unit->z];
			Collect[temp,z]/.z->unit]
(*
:[font = input; initialization; dontPreserveAspect]
*)
Attributes[ordinarySeries] = {HoldFirst}
(*
:[font = input; initialization; dontPreserveAspect]
*)
ordinarySeries[x0_:0,numTerms_:10]:=
	Block[{i,a,deltapwr,z,goal,y,rhs,termsK,sub,coeff},
		deltapwr=allPowers;
		y=Collect[Sum[a[i] xmx0^i,
				{i,k-(Max[deltapwr]-Min[deltapwr]),k}],
				xmx0];
		(*Print["y=",Short[y,2]];*)
		goal=expandCompletely[de[xmx0,y],xmx0];
		(*Print["goal=",goal];*)
		termsK=Coefficient[goal,xmx0^(k+Min[deltapwr])];
		(*Print["Coeff =",termsK];*)
		{rhs}=Solve[(termsK/.a[k]->cc)==0,cc];
		rhs=Factor[rhs[[1,2]]];(* Extract formula *)
		Print["a[k] = ",rhs];
		y=Sum[a[k] xmx0^(k),
					{k,0,numTerms}]+O[xmx0]^(numTerms+1);
		sub=LogicalExpand[
						Collect[de[xmx0,y],xmx0]==0];
		(*Print["subst=",sub];*)
		{coeff}=Solve[sub,Table[a[n-i],{i,0,numTerms}]];
		(*Print[coeff];*)
		y/.coeff/.xmx0->(x-x0) ]

(*
:[font = input; initialization; dontPreserveAspect]
*)
classify[x0_]:= Which[
		TrueQ[Limit[p[2],xmx0->0]!=0],
				Print[x0," is an ordinary point"],
		NumberQ[Limit[p[1]/p[2]*xmx0,xmx0->0]]&&
		NumberQ[Limit[p[0]/p[2]*xmx0^2,xmx0->0]],
				Print[x0," is a regular singular point"],
		True,	Print[x0," is an irregular singular point."]
		  		]
(*
:[font = input; initialization; dontPreserveAspect]
*)
varPar[basisOfKernel_,f_,leading_]:=
	Block[{w,i,iw,rhs,uList,n},
		n=Length[basisOfKernel]-1;
		w=Table[D[y,{x,i}],{i,0,n}];
		iw=Inverse[w];
		rhs=Table[0,{i,1,n+1}];
		rhs[[n+1]]=f/leading;
		loadIntegral;
		uList=Integrate[iw.rhs,x];
		Return[uList.y] ]
	
(*
:[font = input; initialization; dontPreserveAspect]
*)
getIndices[x_]:=Block[{deltapwr,ind,r1,r2,rp,indices},
	deltapwr=allPowers;
	ind=Coefficient[
			Coefficient[Expand[de[x,a[0] x^rp]],
				x^(rp+Min[deltapwr])],
			a[0]];
	Print[ind];
	indices=Solve[ind==0,rp];
	Print[indices];
	r1=indices[[1,1,2]];
	r2=indices[[2,1,2]];
	{r1,r2}]
	
(*
:[font = input; initialization; dontPreserveAspect]
*)
regSingSeries[r_,x0_,numTerms_]:=
	Block[{deltapwr,i,a,rt,goal,y,rhs,termsK,sub,coeff},
		deltapwr=allPowers;
		y=Sum[a[i] xmx0^(i+rt),
			{i,k-(Max[deltapwr]-Min[deltapwr]),k}
				];
		(*Print["y=",Short[y/.rt->r,2]];*)
		goal=expandCompletely[de[xmx0,y],xmx0];
		(*Print["goal=",goal];*)
		termsK=Coefficient[goal,xmx0^(k+Min[deltapwr]+rt)];
		(*Print["Coeff xmx0^(k+(",Min[deltapwr],")+rt) =",
				termsK];*)
		{rhs}=Solve[(termsK/.a[k]->cc)==0,cc];
		rhs=Factor[rhs[[1,2]]];
		Print["a[k]=",rhs/.rt->r];
		y=Sum[a[k] xmx0^(k+rt),
					{k,0,numTerms}]+O[xmx0]^(numTerms+1);
		sub=LogicalExpand[
						Collect[
						Expand[(de[xmx0,y]/xmx0^(-1+rt)/.rt->r)
							],xmx0]==0];
		(*Print["subst=",sub];*)
		sub=sub;
		{coeff}=Solve[Drop[sub,-1],
						Table[a[n-i],{i,0,numTerms}]];
		(*Print[coeff];*)
		y/.coeff/.rt->r/.xmx0->(x-x0) ]

(*
:[font = input; dontPreserveAspect]
(* This "package" operates in the calling context! *)
^*)
