function [K_N_1,K_history_vec] = DRDE(A,B,Q,R,Qf,N);

n = size(A,1);

% boundary condition
K_0 = Qf; 
K_0_vec = mtx2vec(K_0); 
K_history_vec = K_0_vec;
K_i = K_0;

% solve Riccati Differential Equation 
for i=1:N-1
    K_i = A'*K_i*inv(eye(n)+B*inv(R)*B'*K_i)*A + Q;
    K_i_vec = mtx2vec(K_i);
    K_history_vec = [K_history_vec K_i_vec];
end

% constant feedback gain K(N-1) for RHTC
[s1,s2] = size(K_history_vec); 
K_N_1 = vec2mtx(K_history_vec(:,s2),n);
[XX,LL,GG,RR] = DARE(A,B,Q,R,zeros(2,1),eye(2));
return