function  [ x,y,u ]  = dlqtc( x0,A,B,C,Q,R,yr,is );

%
%DLQTC Discrete-time LQTC for Unconstrained Systems
%

%------------------------
% convert reference vector to row vector
%------------------------
[s1,s2] = size(yr);
if (s2 == 1)
   yr = yr';
end

%------------------------
% Riccati solution P & gains for LQTC
%------------------------
n = size(A,1);
P = zeros(n);
e_tr = inf;

% stopping criterion
while (~(e_tr < 10e-10))  
    Pj = P;
    P = A'*P*inv(eye(n)+B*inv(R)*B'*P)*A + C'*Q*C;
    e_tr = abs(trace(P-Pj));
end

GAIN_g = -inv(eye(n)-A'*inv(eye(n)+P*B*inv(R)*B'));
GAIN_u = -inv(R+B'*P*B)*B';

%------------------------
% initialization of history variables
%------------------------
xi = x0; % state of plant x(i)
ui_history = []; % history of rhc u(i)
xi_history = x0; % history of state of plant x(i)
yi_history = C*x0; % history of output of plant y(i)
 
for i=1:is   
   %------------------------
   % time-varying feed feedward gain g for LQTC
   %------------------------
   gi = GAIN_g*C'*Q*yr(:,i);
   %------------------------
   % LQ tracking controller u(i)
   %------------------------
   ui = GAIN_u*(P*A*xi + gi);
   %------------------------
   % plant is controlled by LQTC u(i) at time [i,i+1]
   %------------------------
   xi = A*xi + B*ui;
   yi = C*xi;

   ui_history = [ui_history ui];
   xi_history = [xi_history xi];
   yi_history = [yi_history yi];   
end

x = xi_history; % state trajectory x
y = yi_history; % output trajectory y
u = ui_history; % LQTC history vector u

return